/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.data.transform.name.HostRenamer;
import com.ibm.nmon.data.transform.name.HostRenamerFactory;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.annotate.AnnotationCache;
import com.ibm.nmon.gui.data.RemoveAllDataSetsAction;
import com.ibm.nmon.gui.file.FileLoadAction;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.interval.IntervalManagerDialog;
import com.ibm.nmon.gui.interval.RemoveAllIntervalsAction;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.util.GranularityDialog;
import com.ibm.nmon.gui.util.LogViewerDialog;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import com.ibm.nmon.util.TimeFormatCache;
import com.ibm.nmon.util.VersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

final class MainMenu
extends JMenuBar
implements IntervalListener,
DataSetListener,
PropertyChangeListener {
    private static final long serialVersionUID = -7255908769208090151L;
    private final NMONVisualizerGui gui;
    private int oracleJVMHeapDumpCount = 1;

    MainMenu(NMONVisualizerGui gui) {
        assert (gui != null);
        this.gui = gui;
        this.add(this.createFileMenu());
        this.add(this.createViewMenu());
        this.add(this.createIntervalsMenu());
        this.add(this.createOptionsMenu());
        this.add(this.createHelpMenu());
        gui.getIntervalManager().addListener(this);
        gui.addDataSetListener(this);
        gui.addPropertyChangeListener("chartsDisplayed", this);
        gui.addPropertyChangeListener("timeZone", this);
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        JMenuItem item = new JMenuItem("Load...");
        item.setMnemonic('l');
        item.addActionListener(new FileLoadAction(this.gui));
        item.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Remove All");
        item.setMnemonic('a');
        item.setIcon(Styles.CLEAR_ICON);
        item.setEnabled(false);
        item.addActionListener(new RemoveAllDataSetsAction(this.gui, this.gui.getMainFrame()));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic('x');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.exit();
            }
        });
        menu.add(item);
        return menu;
    }

    private JMenu createIntervalsMenu() {
        JMenu menu = new JMenu("Intervals");
        menu.setMnemonic('i');
        ButtonGroup group = new ButtonGroup();
        JMenuItem item = new IntervalMenuItem(Interval.DEFAULT);
        item.setText(TimeFormatCache.formatInterval(Interval.DEFAULT));
        item.setMnemonic('a');
        item.setSelected(true);
        item.setAccelerator(KeyStroke.getKeyStroke(48, 640));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.getIntervalManager().setCurrentInterval(Interval.DEFAULT);
            }
        });
        AbstractAction doClick = new AbstractAction(){
            private static final long serialVersionUID = -9151414102717456362L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JMenuItem)e.getSource()).doClick();
            }
        };
        item.getActionMap().put("doClick", doClick);
        InputMap inputMap = item.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(96, 640), "doClick");
        group.add(item);
        menu.add(item);
        menu.addSeparator();
        if (this.gui.getIntervalManager().getIntervalCount() != 0) {
            int n = 1;
            for (Interval interval : this.gui.getIntervalManager().getIntervals()) {
                item = new IntervalMenuItem(interval);
                if (n < 10) {
                    item.getActionMap().put("doClick", doClick);
                    inputMap = item.getInputMap(2);
                    inputMap.put(KeyStroke.getKeyStroke(48 + n, 640), "doClick");
                    inputMap.put(KeyStroke.getKeyStroke(96 + n, 640), "doClick");
                    ++n;
                }
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainMenu.this.gui.getIntervalManager().setCurrentInterval(((IntervalMenuItem)e.getSource()).getInterval());
                    }
                });
                group.add(item);
                if (interval.equals(this.gui.getIntervalManager().getCurrentInterval())) {
                    item.setSelected(true);
                }
                menu.add(item);
            }
            menu.addSeparator();
            item = new JMenuItem("Remove All");
            item.setMnemonic('r');
            item.setIcon(Styles.CLEAR_ICON);
            item.addActionListener(new RemoveAllIntervalsAction(this.gui, this.gui.getMainFrame()));
            item.setAccelerator(KeyStroke.getKeyStroke(127, 128));
            menu.add(item);
        } else {
            item = new JMenuItem("<No Intervals>");
            item.setEnabled(false);
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem("Manage...");
        item.setMnemonic('m');
        item.setIcon(Styles.INTERVAL_ICON);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new IntervalManagerDialog(MainMenu.this.gui).setVisible(true);
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        menu.add(item);
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic('v');
        JMenuItem item = new JMenuItem("Set Granularity...");
        item.setMnemonic('g');
        item.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new GranularityDialog(MainMenu.this.gui, MainMenu.this.gui.getMainFrame()).setVisible(true);
            }
        });
        menu.add(item);
        menu.addSeparator();
        JMenu chartSubMenu = new JMenu("Chart");
        chartSubMenu.setMnemonic('c');
        chartSubMenu.setEnabled(false);
        item = new JMenuItem("Table Columns...");
        item.setMnemonic('c');
        item.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.getViewManager().displayTableColumnChooser();
            }
        });
        chartSubMenu.add(item);
        JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem("Relative Time");
        checkItem.setMnemonic('r');
        checkItem.setSelected(this.gui.getBooleanProperty("chartRelativeTime"));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("chartRelativeTime", ((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        chartSubMenu.add(checkItem);
        chartSubMenu.addSeparator();
        item = new JMenuItem("Clear Annotations");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationCache.clear();
            }
        });
        chartSubMenu.add(item);
        item = new JMenuItem("Remove Last Line");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationCache.removeLastMarker();
            }
        });
        chartSubMenu.add(item);
        item = new JMenuItem("Remove Last Text");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationCache.removeLastAnnotation();
            }
        });
        chartSubMenu.add(item);
        menu.add(chartSubMenu);
        menu.addSeparator();
        checkItem = new JCheckBoxMenuItem("Summary Table");
        checkItem.setMnemonic('t');
        checkItem.setIcon(Styles.buildIcon("table.png"));
        checkItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        checkItem.setSelected(!this.gui.getBooleanProperty("chartsDisplayed"));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("chartsDisplayed", !((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        menu.add(checkItem);
        item = new JMenuItem("Custom Report...");
        item.setMnemonic('r');
        item.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        item.setIcon(Styles.REPORT_ICON);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.showReportFrame();
            }
        });
        menu.add(item);
        return menu;
    }

    private JMenu createOptionsMenu() {
        JMenu menu = new JMenu("Options");
        menu.setMnemonic('o');
        JMenu namingSubMenu = new JMenu("Name Systems");
        ButtonGroup group = new ButtonGroup();
        String systemsNamedBy = this.gui.getProperty("systemsNamedBy");
        JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem("By Hostname");
        checkItem.setSelected("host".equals(systemsNamedBy));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("systemsNamedBy", "host");
                MainMenu.this.gui.setHostRenamer(HostRenamer.BY_HOST);
            }
        });
        namingSubMenu.add(checkItem);
        group.add(checkItem);
        checkItem = new JCheckBoxMenuItem("By LPAR Name");
        checkItem.setSelected("lpar".equals(systemsNamedBy));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("systemsNamedBy", "lpar");
                MainMenu.this.gui.setHostRenamer(HostRenamer.BY_LPAR);
            }
        });
        namingSubMenu.add(checkItem);
        group.add(checkItem);
        checkItem = new JCheckBoxMenuItem("By NMON Run Name");
        checkItem.setSelected("run".equals(systemsNamedBy));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("systemsNamedBy", "run");
                MainMenu.this.gui.setHostRenamer(HostRenamer.BY_RUN);
            }
        });
        namingSubMenu.add(checkItem);
        group.add(checkItem);
        checkItem = new JCheckBoxMenuItem("By Custom File...");
        checkItem.setSelected("custom".equals(systemsNamedBy));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIFileChooser chooser = new GUIFileChooser(MainMenu.this.gui, "Select Hostname Definitions", "hostnames.json");
                if (chooser.showDialog(MainMenu.this.gui.getMainFrame(), "Load") == 0) {
                    try {
                        HostRenamer renamer = HostRenamerFactory.loadFromFile(chooser.getSelectedFile());
                        MainMenu.this.gui.setProperty("systemsNamedBy", "custom");
                        MainMenu.this.gui.setHostRenamer(renamer);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), "Error parsing file '" + chooser.getSelectedFile().getName() + "'.\n" + ex.getMessage(), "Parse Error", 0);
                        ButtonGroup group = ((DefaultButtonModel)((JCheckBoxMenuItem)e.getSource()).getModel()).getGroup();
                        group.getElements().nextElement().doClick();
                    }
                }
            }
        });
        namingSubMenu.add(checkItem);
        group.add(checkItem);
        menu.add(namingSubMenu);
        checkItem = new JCheckBoxMenuItem("Scale Process Data by CPUs");
        checkItem.setMnemonic('c');
        checkItem.setSelected(this.gui.getBooleanProperty("scaleProcessesByCPUs"));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("scaleProcessesByCPUs", ((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        menu.add(checkItem);
        checkItem = new JCheckBoxMenuItem("Show Status Bar");
        checkItem.setMnemonic('b');
        checkItem.setSelected(this.gui.getBooleanProperty("showStatusBar"));
        checkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.gui.setProperty("showStatusBar", ((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        menu.add(checkItem);
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic('h');
        JMenuItem item = new JMenuItem("What Now?");
        item.setIcon(Styles.buildIcon("help.png"));
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = null;
                message = MainMenu.this.gui.getDataSetCount() == 0 ? "Parse some files by:\n\n1) Selecting 'Load' from the File menu,\n2) Right clicking on the left hand side\n    of the application\n3) Dragging files from the filesystem\n    onto the left hand side of the application\n4) CTRL-O" : (MainMenu.this.gui.getIntervalManager().getIntervalCount() == 0 ? "Double click on the list of parsed systems to expand them.\n\nSelecting a system will display a summary report.\nSelecting a metric will graph those values.\nRight clicking on the system name will bring up system information.\n\nAdd intervals by going to the Intervals menu and selecting Manage Intervals (or CTRL-I)" : "Select the interval you want to analyze.\n\nView charts for that interval by clicking on the system tree.\nView summary information for that interval in the summary table (see the 'View' menu).\n\nRight clicking will bring up context sensitive menus");
                JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), message, "What Now?", 1);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("View Log...");
        item.setMnemonic('l');
        item.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        item.setIcon(LogViewerDialog.LOG_ICON);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MainMenu.this.gui.getLogViewer().isVisible()) {
                    MainMenu.this.gui.getLogViewer().setVisible(true);
                } else {
                    MainMenu.this.gui.getLogViewer().toFront();
                }
                MainMenu.this.gui.getLogViewer().setLocationRelativeTo(MainMenu.this.gui.getMainFrame());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Java Info");
        item.setMnemonic('j');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long totalHeapUsage = 0L;
                long maxHeapUsage = 0L;
                StringBuilder builder = new StringBuilder(1024);
                builder.append(System.getProperty("java.runtime.name"));
                builder.append('\n');
                builder.append("Version ");
                builder.append(": ");
                builder.append(System.getProperty("java.runtime.version"));
                builder.append('\n');
                builder.append("Java Home");
                builder.append(": ");
                builder.append(System.getProperty("java.home"));
                builder.append('\n');
                builder.append('\n');
                builder.append("Classpath");
                builder.append('\n');
                builder.append(System.getProperty("java.class.path").replace(';', '\n'));
                builder.append('\n');
                builder.append('\n');
                builder.append("Memory Pools");
                builder.append('\n');
                for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                    long used = pool.getUsage().getUsed();
                    long max = pool.getUsage().getMax();
                    max = max == -1L ? pool.getUsage().getCommitted() : max;
                    builder.append(pool.getName());
                    builder.append(": ");
                    builder.append(Styles.NUMBER_FORMAT.format((double)used / 1024.0 / 1024.0));
                    builder.append(" MB");
                    builder.append(" (of ");
                    builder.append(Styles.NUMBER_FORMAT.format((double)max / 1024.0 / 1024.0));
                    builder.append(" max)");
                    builder.append('\n');
                    totalHeapUsage += used;
                    maxHeapUsage += max;
                }
                builder.append('\n');
                builder.append("Total Heap Usage");
                builder.append('\n');
                builder.append(Styles.NUMBER_FORMAT.format((double)totalHeapUsage / 1024.0 / 1024.0));
                builder.append(" MB");
                builder.append(" (of ");
                builder.append(Styles.NUMBER_FORMAT.format((double)maxHeapUsage / 1024.0 / 1024.0));
                builder.append(" max)");
                JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), builder.toString(), "Java Info", 1);
            }
        });
        menu.add(item);
        item = new JMenuItem("Heap Dump");
        item.setMnemonic('d');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String vmVendor = System.getProperty("java.vm.vendor");
                if (vmVendor.contains("IBM")) {
                    try {
                        Class<?> ibmDump = Class.forName("com.ibm.jvm.Dump");
                        Method ibmHeapDump = ibmDump.getMethod("HeapDump", new Class[0]);
                        ibmHeapDump.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), "Could not complete heap dump on IBM JVM\n\n" + e.getClass().getName() + ": " + e.getMessage(), "Heap Dump Error", 0);
                    }
                } else if (vmVendor.contains("Oracle")) {
                    String pid = ManagementFactory.getRuntimeMXBean().getName();
                    pid = pid.substring(0, pid.indexOf(64));
                    Date now = new Date();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss.");
                    DecimalFormat numberFormat = new DecimalFormat("0000");
                    String filename = "./heapdump." + dateFormat.format(now) + pid + '.' + numberFormat.format(MainMenu.this.oracleJVMHeapDumpCount++) + ".hprof";
                    try {
                        Class<?> sunVM = Class.forName("sun.tools.attach.HotSpotVirtualMachine");
                        Method sunVMAttach = sunVM.getMethod("attach", String.class);
                        Object attachedVM = sunVMAttach.invoke(null, pid);
                        Class<?> actualVMClass = attachedVM.getClass();
                        Method dumpHeap = actualVMClass.getMethod("dumpHeap", Object[].class);
                        dumpHeap.invoke(attachedVM, new Object[]{new Object[]{filename, "-all"}});
                        Method detach = actualVMClass.getMethod("detach", new Class[0]);
                        detach.invoke(attachedVM, new Object[0]);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), "Could not complete heap dump on Oracle JVM\n\n" + e.getClass().getName() + ": " + e.getMessage() + "\n\nAre you running a JDK?\nIs tools.jar in the classpath?", "Heap Dump Error", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), "Could not complete heap dump on " + vmVendor + " JVM\n\n", "Heap Dump Error", 0);
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("Run GC");
        item.setMnemonic('g');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long total = 0L;
                for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                    total += pool.getUsage().getUsed();
                }
                double before = (double)total / 1024.0 / 1024.0;
                System.gc();
                System.gc();
                Thread.yield();
                total = 0L;
                for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                    total += pool.getUsage().getUsed();
                }
                double after = (double)total / 1024.0 / 1024.0;
                JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), "Heap Free Before GC: " + Styles.NUMBER_FORMAT.format(before) + " MB" + '\n' + "Heap Free After GC: " + Styles.NUMBER_FORMAT.format(after) + " MB", "Garbage Collection", 1);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("About");
        item.setMnemonic('a');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainMenu.this.gui.getMainFrame(), "Copyright \u00a9 2011-2014\nIBM Software Group, Collaboration Services.\nAll Rights Reserved.\n\nSupport is on an 'as-is', 'best-effort' basis only.\n\nVersion " + VersionInfo.getVersion() + "\n\n" + "Icons from " + "http://www.famfamfam.com/lab/icons/silk/" + "\n" + "Creative Commons Attribution 2.5" + " License\n(" + "http://creativecommons.org/licenses/by/2.5/legalcode" + ")", "NMON Visualizer", 1);
            }
        });
        menu.add(item);
        return menu;
    }

    @Override
    public void intervalsCleared() {
        this.remove(2);
        this.add((Component)this.createIntervalsMenu(), 2);
    }

    @Override
    public void intervalRemoved(Interval interval) {
        this.remove(2);
        this.add((Component)this.createIntervalsMenu(), 2);
    }

    @Override
    public void intervalAdded(Interval interval) {
        this.remove(2);
        this.add((Component)this.createIntervalsMenu(), 2);
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        JMenu intervals = this.getMenu(2);
        for (int i = 0; i < intervals.getItemCount(); ++i) {
            IntervalMenuItem intervalItem;
            JMenuItem item = intervals.getItem(i);
            if (item == null || item.getClass() != IntervalMenuItem.class || !(intervalItem = (IntervalMenuItem)item).getInterval().equals(interval)) continue;
            intervalItem.setSelected(true);
            break;
        }
    }

    @Override
    public void intervalRenamed(Interval interval) {
        JMenu intervals = this.getMenu(2);
        for (int i = 0; i < intervals.getItemCount(); ++i) {
            IntervalMenuItem intervalItem;
            JMenuItem item = intervals.getItem(i);
            if (item == null || item.getClass() != IntervalMenuItem.class || !(intervalItem = (IntervalMenuItem)item).getInterval().equals(interval)) continue;
            intervalItem.setText(TimeFormatCache.formatInterval(interval));
            break;
        }
    }

    @Override
    public void dataAdded(DataSet data) {
        JMenuItem item = this.getMenu(0).getItem(2);
        item.setEnabled(true);
        this.changeDefaultIntervalName();
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.changeDefaultIntervalName();
    }

    @Override
    public void dataChanged(DataSet data) {
        this.changeDefaultIntervalName();
    }

    @Override
    public void dataCleared() {
        JMenuItem item = this.getMenu(0).getItem(2);
        item.setEnabled(false);
        this.changeDefaultIntervalName();
        this.enableChartSubMenu(false);
    }

    private void changeDefaultIntervalName() {
        JMenuItem item = this.getMenu(2).getItem(0);
        item.setText(TimeFormatCache.formatInterval(Interval.DEFAULT));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chartsDisplayed".equals(evt.getPropertyName())) {
            boolean chartsDisplayed = (Boolean)evt.getNewValue();
            this.enableChartSubMenu(chartsDisplayed);
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)this.getMenu(1).getItem(4);
            item.setSelected(!chartsDisplayed);
        } else if ("timeZone".equals(evt.getPropertyName())) {
            for (Interval interval : this.gui.getIntervalManager().getIntervals()) {
                this.intervalRenamed(interval);
            }
        }
    }

    void enableChartSubMenu(boolean enabled) {
        JMenuItem item = this.getMenu(1).getItem(2);
        if (item.isEnabled() != enabled) {
            item.setEnabled(enabled);
        }
    }

    private final class IntervalMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = -7947301490892979513L;
        private final Interval interval;

        public IntervalMenuItem(Interval interval) {
            super(TimeFormatCache.formatInterval(interval));
            this.interval = interval;
        }

        public Interval getInterval() {
            return this.interval;
        }
    }
}

