/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.NMONVisualizerApp;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.transform.name.HostRenamer;
import com.ibm.nmon.file.CombinedFileFilter;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.file.ParserRunner;
import com.ibm.nmon.gui.interval.IntervalPicker;
import com.ibm.nmon.gui.main.ChartTableToggle;
import com.ibm.nmon.gui.main.MainMenu;
import com.ibm.nmon.gui.main.StatusBar;
import com.ibm.nmon.gui.main.ViewManager;
import com.ibm.nmon.gui.parse.HATJPostParser;
import com.ibm.nmon.gui.parse.IOStatPostParser;
import com.ibm.nmon.gui.parse.VerboseGCPreParser;
import com.ibm.nmon.gui.report.ReportFrame;
import com.ibm.nmon.gui.tree.TreePanel;
import com.ibm.nmon.gui.util.LogViewerDialog;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.report.ReportCache;
import com.ibm.nmon.util.FileHelper;
import com.ibm.nmon.util.GranularityHelper;
import com.ibm.nmon.util.TimeFormatCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class NMONVisualizerGui
extends NMONVisualizerApp {
    private static final String DEFAULT_WINDOW_TITLE = "NMON Visualizer";
    private final Preferences preferences;
    private final JFrame mainFrame;
    private final MainMenu menu;
    private final LogViewerDialog logViewer;
    private VerboseGCPreParser gcPreParser;
    private IOStatPostParser ioStatPostParser;
    private HATJPostParser hatJPostParser;
    private final GranularityHelper granularityHelper;
    private final ReportCache reportCache;
    private WindowAdapter windowManager = new WindowAdapter(){

        @Override
        public void windowOpened(WindowEvent e) {
            JSplitPane lrSplitPane = (JSplitPane)NMONVisualizerGui.this.mainFrame.getContentPane();
            lrSplitPane.setDividerLocation(0.2);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NMONVisualizerGui.this.exit();
        }
    };

    public static void main(final String[] args) throws Exception {
        UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NMONVisualizerGui gui = new NMONVisualizerGui();
                    gui.getMainFrame().setVisible(true);
                    if (args.length > 0) {
                        gui.logger.info("starting with files {}", (Object)Arrays.toString(args));
                        File[] files = new File[args.length];
                        for (int i = 0; i < args.length; ++i) {
                            files[i] = new File(args[i]);
                        }
                        ArrayList<String> toParse = new ArrayList<String>();
                        gui.logger.debug("parsing files {}", toParse);
                        FileHelper.recurseDirectories(files, (FileFilter)CombinedFileFilter.getInstance(false), toParse);
                        new Thread((Runnable)new ParserRunner(gui, toParse, gui.getDisplayTimeZone()), this.getClass().getName() + " Parser").start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public NMONVisualizerGui() throws Exception {
        this.granularityHelper = new GranularityHelper(this);
        this.setGranularity(-1);
        this.reportCache = new ReportCache();
        this.preferences = Preferences.userNodeForPackage(NMONVisualizerGui.class);
        this.setProperty("chartsDisplayed", true);
        String systemsNamedBy = this.preferences.get("systemsNamedBy", null);
        if (systemsNamedBy != null) {
            if ("host".equals(systemsNamedBy)) {
                this.setHostRenamer(HostRenamer.BY_HOST);
            } else if ("lpar".equals(systemsNamedBy)) {
                this.setHostRenamer(HostRenamer.BY_LPAR);
            } else if ("run".equals(systemsNamedBy)) {
                this.setHostRenamer(HostRenamer.BY_RUN);
            } else if ("custom".equals(systemsNamedBy)) {
                systemsNamedBy = "host";
            }
            this.setProperty("systemsNamedBy", systemsNamedBy);
        }
        this.setProperty("scaleProcessesByCPUs", this.preferences.get("scaleProcessesByCPUs", this.getProperty("scaleProcessesByCPUs")));
        this.setProperty("showStatusBar", this.preferences.get("showStatusBar", "false"));
        this.mainFrame = new JFrame(DEFAULT_WINDOW_TITLE);
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(this.windowManager);
        this.mainFrame.setIconImage(Styles.IBM_ICON.getImage());
        this.menu = new MainMenu(this);
        this.mainFrame.setJMenuBar(this.menu);
        this.logViewer = new LogViewerDialog(this);
        JSplitPane lrSplitPane = new JSplitPane(1);
        lrSplitPane.setResizeWeight(0.0);
        this.mainFrame.setContentPane(lrSplitPane);
        TreePanel treePanel = new TreePanel(this);
        JPanel right = new JPanel(new BorderLayout());
        lrSplitPane.setLeftComponent(treePanel);
        lrSplitPane.setRightComponent(right);
        ChartTableToggle toggle = new ChartTableToggle(this);
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)new IntervalPicker(this), "Center");
        top.add((Component)toggle, "After");
        right.add((Component)top, "First");
        ViewManager dataPanel = new ViewManager(this);
        StatusBar statusBar = new StatusBar(this);
        treePanel.addTreeSelectionListener(dataPanel);
        treePanel.addTreeSelectionListener(statusBar);
        right.add((Component)dataPanel, "Center");
        right.add((Component)statusBar, "Last");
        this.mainFrame.pack();
        this.positionMainFrame();
    }

    public final Preferences getPreferences() {
        return this.preferences;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public ViewManager getViewManager() {
        return (ViewManager)((JPanel)((JSplitPane)this.mainFrame.getContentPane()).getRightComponent()).getComponent(1);
    }

    public void showReportFrame() {
        ReportFrame report = new ReportFrame(this);
        report.setVisible(true);
    }

    public LogViewerDialog getLogViewer() {
        return this.logViewer;
    }

    public int getGranularity() {
        return this.granularityHelper.getGranularity();
    }

    public void setGranularity(int granularity) {
        int oldGranularity = this.getGranularity();
        if (granularity <= 0) {
            if (this.getBooleanProperty("automaticGranularity")) {
                this.granularityHelper.recalculate();
            } else {
                this.granularityHelper.setAutomatic(true);
                this.setProperty("automaticGranularity", true);
            }
        } else {
            this.granularityHelper.setGranularity(granularity);
            if (this.getBooleanProperty("automaticGranularity")) {
                this.setProperty("automaticGranularity", false);
            }
        }
        if (this.getGranularity() != oldGranularity) {
            for (DataSet dataSet : this.getDataSets()) {
                this.getAnalysis(dataSet).setGranularity(this.getGranularity());
            }
            this.setProperty("granularity", this.getGranularity());
        }
    }

    public ReportCache getReportCache() {
        return this.reportCache;
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        super.currentIntervalChanged(interval);
        if (this.getBooleanProperty("automaticGranularity")) {
            this.setGranularity(-1);
        }
        this.updateWindowTitle(interval);
    }

    @Override
    public void intervalRenamed(Interval interval) {
        super.intervalRenamed(interval);
        if (this.getIntervalManager().getCurrentInterval().equals(interval)) {
            this.updateWindowTitle(interval);
        }
    }

    private void updateWindowTitle(Interval interval) {
        if (this.getMinSystemTime() > 0L && this.getMaxSystemTime() < Long.MAX_VALUE) {
            this.mainFrame.setTitle("NMON Visualizer - " + TimeFormatCache.formatInterval(interval));
        } else {
            this.mainFrame.setTitle(DEFAULT_WINDOW_TITLE);
        }
    }

    void exit() {
        int confirm = JOptionPane.showConfirmDialog(this.mainFrame, "Are you sure you want to Exit?", "Exit?", 0, 3);
        if (confirm == 0) {
            if ((this.mainFrame.getExtendedState() & 6) != 0) {
                this.getPreferences().putBoolean("WindowMaximized", true);
            } else {
                this.getPreferences().putBoolean("WindowMaximized", false);
                this.getPreferences().putInt("WindowPosX", this.mainFrame.getX());
                this.getPreferences().putInt("WindowPosY", this.mainFrame.getY());
                this.getPreferences().putInt("WindowSizeX", (int)this.mainFrame.getSize().getWidth());
                this.getPreferences().putInt("WindowSizeY", (int)this.mainFrame.getSize().getHeight());
            }
            for (Frame frame : Frame.getFrames()) {
                if (frame.getClass() != ReportFrame.class) continue;
                ((ReportFrame)frame).setVisible(false);
                ((ReportFrame)frame).dispose();
            }
            this.getPreferences().put("systemsNamedBy", this.getProperty("systemsNamedBy"));
            this.getPreferences().put("scaleProcessesByCPUs", this.getProperty("scaleProcessesByCPUs"));
            this.getPreferences().put("showStatusBar", this.getProperty("showStatusBar"));
            this.logViewer.dispose();
            this.mainFrame.dispose();
            try {
                this.preferences.sync();
            }
            catch (BackingStoreException e) {
                this.logger.warn("could not save preferences", (Throwable)e);
            }
        }
    }

    @Override
    protected String[] getDataForGCParse(final String fileToParse) {
        if (this.gcPreParser == null) {
            this.gcPreParser = new VerboseGCPreParser(this);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    File file = new File(fileToParse);
                    File parent = file.getParentFile();
                    if (parent != null) {
                        NMONVisualizerGui.this.gcPreParser.setJVMName(parent.getName());
                    }
                    if ((parent = parent.getParentFile()) != null) {
                        NMONVisualizerGui.this.gcPreParser.setHostname(parent.getName());
                    }
                    NMONVisualizerGui.this.gcPreParser.parseDataSet(fileToParse);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("cannot get hostname and JVM name for file '{}'", (Object)fileToParse, (Object)e);
        }
        if (this.gcPreParser.isSkipped()) {
            return null;
        }
        return new String[]{this.gcPreParser.getHostname(), this.gcPreParser.getJVMName()};
    }

    @Override
    protected Object[] getDataForIOStatParse(final String fileToParse, final String hostname) {
        if (this.ioStatPostParser == null) {
            this.ioStatPostParser = new IOStatPostParser(this);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!hostname.equals("iostat")) {
                        NMONVisualizerGui.this.ioStatPostParser.setHostname(hostname);
                    }
                    NMONVisualizerGui.this.ioStatPostParser.parseDataSet(fileToParse);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("cannot get hostname and time zone for file '{}'", (Object)fileToParse, (Object)e);
        }
        if (this.ioStatPostParser.isSkipped()) {
            return null;
        }
        return new Object[]{this.ioStatPostParser.getHostname(), this.ioStatPostParser.getDate()};
    }

    @Override
    protected Object[] getDataForHATJParse(final String fileToParse, final String hostname) {
        if (this.hatJPostParser == null) {
            this.hatJPostParser = new HATJPostParser(this);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!hostname.equals("hatj")) {
                        NMONVisualizerGui.this.hatJPostParser.setHostname(hostname);
                    }
                    NMONVisualizerGui.this.hatJPostParser.parseDataSet(fileToParse);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("cannot get hostname for file '{}'", (Object)fileToParse, (Object)e);
        }
        if (this.hatJPostParser.isSkipped()) {
            return null;
        }
        return new Object[]{this.hatJPostParser.getHostname()};
    }

    private void positionMainFrame() {
        GraphicsDevice[] devices;
        int x = this.getPreferences().getInt("WindowPosX", 0);
        int y = this.getPreferences().getInt("WindowPosY", 0);
        int xSize = this.getPreferences().getInt("WindowSizeX", Integer.MAX_VALUE);
        int ySize = this.getPreferences().getInt("WindowSizeY", Integer.MAX_VALUE);
        boolean willBeVisible = false;
        Rectangle preferred = new Rectangle(x, y, xSize, ySize);
        block0: for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration[] configs;
            for (GraphicsConfiguration config : configs = device.getConfigurations()) {
                if (!SwingUtilities.isRectangleContainingRectangle(config.getBounds(), preferred)) continue;
                willBeVisible = true;
                break block0;
            }
        }
        if (!willBeVisible) {
            Rectangle defaultScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            if (xSize > defaultScreen.width) {
                xSize = 800;
            }
            if (ySize > defaultScreen.height) {
                ySize = 600;
            }
            x = defaultScreen.x + defaultScreen.width / 2 - xSize / 2;
            y = defaultScreen.y + defaultScreen.height / 2 - ySize / 2;
        }
        this.mainFrame.setLocation(new Point(x, y));
        this.mainFrame.setSize(xSize, ySize);
        if (this.getPreferences().getBoolean("WindowMaximized", false)) {
            this.mainFrame.setExtendedState(this.mainFrame.getExtendedState() | 6);
        }
    }

    @Override
    protected void fireDataAdded(final DataSet data) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireDataAdded(data);
            if (this.getBooleanProperty("automaticGranularity")) {
                this.setGranularity(-1);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NMONVisualizerGui.super.fireDataAdded(data);
                    if (NMONVisualizerGui.this.getBooleanProperty("automaticGranularity")) {
                        NMONVisualizerGui.this.setGranularity(-1);
                    }
                }
            });
        }
    }
}

