/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.tree.TreePathParser;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import com.ibm.nmon.interval.IntervalManager;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

final class StatusBar
extends JLabel
implements PropertyChangeListener,
TreeSelectionListener,
IntervalListener,
DataSetListener {
    private static final long serialVersionUID = -6249775876913359902L;
    private static final String NO_SOURCE_FILE = "<NONE>";
    private final IntervalManager intervalManager;
    private SystemDataSet currentData = null;
    private final TreePathParser pathParser = new TreePathParser(){

        @Override
        protected void onNullPath() {
            this.onDataSetPath(null);
        }

        @Override
        protected void onRootPath() {
            this.onDataSetPath(null);
        }

        @Override
        protected void onDataSetPath(DataSet data) {
            if (data == null && StatusBar.this.currentData != null || data != null && !data.equals(StatusBar.this.currentData)) {
                StatusBar.this.currentData = (SystemDataSet)data;
                StatusBar.this.updateStatus(StatusBar.this.intervalManager.getCurrentInterval());
            }
        }

        @Override
        protected void onTypePath(DataSet data, DataType type) {
            this.onDataSetPath(data);
        }

        @Override
        protected void onFieldPath(DataSet data, DataType type, String field) {
            this.onDataSetPath(data);
        }

        @Override
        protected void onProcessPath(DataSet data) {
            this.onDataSetPath(data);
        }
    };

    public StatusBar(NMONVisualizerGui gui) {
        Font font = Styles.LABEL.deriveFont(0);
        this.setText(NO_SOURCE_FILE);
        this.setFont(font);
        this.setForeground(new Color(0x333333));
        this.setHorizontalAlignment(0);
        this.setBackground(new Color(248, 248, 248));
        this.setOpaque(true);
        this.setBorder(Styles.createTopLineBorder(this));
        this.setVisible(gui.getBooleanProperty("showStatusBar"));
        this.intervalManager = gui.getIntervalManager();
        this.intervalManager.addListener(this);
        gui.addPropertyChangeListener("showStatusBar", this);
        gui.addDataSetListener(this);
    }

    private void updateStatus(Interval currentInterval) {
        if (!this.isVisible()) {
            return;
        }
        if (this.currentData == null) {
            this.setText(NO_SOURCE_FILE);
            this.setToolTipText(null);
            return;
        }
        StringBuilder builder = new StringBuilder(128);
        for (Interval interval : this.currentData.getSourceFileIntervals()) {
            if (interval.getStart() > currentInterval.getEnd() || interval.getEnd() < currentInterval.getStart()) continue;
            builder.append(this.currentData.getSourceFile(interval));
            builder.append(" + ");
        }
        if (builder.length() > 3) {
            String text = builder.substring(0, builder.length() - 3);
            this.setText(text);
            this.setToolTipText(text);
        } else {
            this.setText(NO_SOURCE_FILE);
            this.setToolTipText(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setVisible((Boolean)evt.getNewValue());
        this.updateStatus(this.intervalManager.getCurrentInterval());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.pathParser.parse(e.getPath());
    }

    @Override
    public void intervalAdded(Interval interval) {
    }

    @Override
    public void intervalRemoved(Interval interval) {
    }

    @Override
    public void intervalsCleared() {
        this.currentIntervalChanged(this.intervalManager.getCurrentInterval());
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        this.updateStatus(interval);
    }

    @Override
    public void intervalRenamed(Interval interval) {
    }

    @Override
    public void dataAdded(DataSet data) {
        if (data.equals(this.currentData)) {
            this.updateStatus(this.intervalManager.getCurrentInterval());
        }
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.dataAdded(data);
    }

    @Override
    public void dataChanged(DataSet data) {
        this.dataAdded(data);
    }

    @Override
    public void dataCleared() {
    }
}

