/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.builder.ChartBuilderPlugin;
import com.ibm.nmon.gui.main.ChartSplitPane;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.report.ReportPanel;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;

final class SummaryView
extends ChartSplitPane
implements IntervalListener {
    private static final long serialVersionUID = 3407771704687182117L;
    private final ReportPanel singleIntervalReport;
    private final ReportPanel allIntervalsReport;
    private final JCheckBox allIntervals;
    private String lastCommonTabName;

    public SummaryView(NMONVisualizerGui gui) {
        super(gui, gui.getMainFrame());
        this.singleIntervalReport = new ReportPanel(gui, "summary");
        this.singleIntervalReport.setBorder(null);
        this.singleIntervalReport.addPlugin(new ChartBuilderPlugin(){

            @Override
            public void configureChart(JFreeChart chart) {
                if (chart.getPlot() instanceof CategoryPlot) {
                    CategoryPlot plot = (CategoryPlot)chart.getPlot();
                    plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                }
            }
        });
        this.allIntervalsReport = new ReportPanel(gui, "interval");
        this.allIntervalsReport.setBorder(null);
        this.allIntervals = new JCheckBox("Graph All Intervals");
        this.allIntervals.setEnabled(false);
        this.allIntervals.setSelected(false);
        this.allIntervals.setFont(Styles.LABEL);
        this.allIntervals.setHorizontalAlignment(4);
        this.allIntervals.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.allIntervals.setBorderPainted(true);
        this.allIntervals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.this.toggleReports();
            }
        });
        this.setTopComponent(this.singleIntervalReport);
        this.addBorderIfNecessary();
        this.setEnabled(false);
        gui.addDataSetListener(this);
        gui.getIntervalManager().addListener(this);
        JPanel right = (JPanel)((JSplitPane)gui.getMainFrame().getContentPane()).getRightComponent();
        JPanel top = (JPanel)right.getComponent(0);
        top.add((Component)this.allIntervals, "Before");
        ActionMap actions = this.allIntervals.getActionMap();
        InputMap inputs = this.allIntervals.getInputMap(2);
        actions.put("allIntervals", new AbstractAction(){
            private static final long serialVersionUID = -442106516679509723L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.this.allIntervals.doClick();
            }
        });
        inputs.put(KeyStroke.getKeyStroke(73, 192), "allIntervals");
        this.allIntervalsReport.addPropertyChangeListener("chart", this.summaryTable);
        this.allIntervalsReport.addPropertyChangeListener("highlightedLine", this);
        this.allIntervalsReport.addPropertyChangeListener("highlightedBar", this);
        this.allIntervalsReport.addPropertyChangeListener("highlightedIntervalLine", this);
        this.singleIntervalReport.addPropertyChangeListener("chart", this.summaryTable);
        this.singleIntervalReport.addPropertyChangeListener("highlightedLine", this);
        this.singleIntervalReport.addPropertyChangeListener("highlightedBar", this);
        this.allIntervalsReport.addPropertyChangeListener("chart", this);
        this.allIntervalsReport.addPropertyChangeListener("annotation", this);
        this.singleIntervalReport.addPropertyChangeListener("chart", this);
        this.singleIntervalReport.addPropertyChangeListener("annotation", this);
    }

    @Override
    protected BaseChartPanel getChartPanel() {
        if (this.allIntervalsReport.isEnabled()) {
            return this.allIntervalsReport.getChartPanel();
        }
        return this.singleIntervalReport.getChartPanel();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            if (enabled) {
                if (this.allIntervals.isSelected()) {
                    this.allIntervalsReport.setEnabled(true);
                } else {
                    this.singleIntervalReport.setEnabled(true);
                }
                if (this.gui.getIntervalManager().getIntervalCount() > 0) {
                    this.allIntervals.setEnabled(true);
                }
            } else {
                this.allIntervalsReport.setEnabled(false);
                this.singleIntervalReport.setEnabled(false);
                this.allIntervals.setEnabled(false);
            }
        }
    }

    @Override
    protected void saveCharts(String directory) {
        if (this.allIntervalsReport.isEnabled()) {
            this.allIntervalsReport.saveAllCharts(directory);
        } else {
            this.singleIntervalReport.saveAllCharts(directory);
        }
    }

    @Override
    public void dataAdded(DataSet data) {
        this.singleIntervalReport.addData(data);
        this.allIntervalsReport.addData(data);
        int index = this.singleIntervalReport.getPreviousTab();
        if (index != -1) {
            if (index >= this.singleIntervalReport.getTabCount()) {
                index = this.singleIntervalReport.getTabCount() - 1;
            }
            this.singleIntervalReport.setSelectedIndex(index);
        } else {
            this.singleIntervalReport.setSelectedIndex(0);
        }
        index = this.allIntervalsReport.getPreviousTab();
        if (index != -1) {
            if (index >= this.allIntervalsReport.getTabCount()) {
                index = this.allIntervalsReport.getTabCount() - 1;
            }
            this.allIntervalsReport.setSelectedIndex(index);
        } else {
            this.allIntervalsReport.setSelectedIndex(0);
        }
        this.addBorderIfNecessary();
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.singleIntervalReport.removeData(data);
        this.allIntervalsReport.removeData(data);
        this.updateLastTab();
        this.addBorderIfNecessary();
    }

    @Override
    public void dataChanged(DataSet data) {
        this.singleIntervalReport.resetReport();
        this.allIntervalsReport.resetReport();
    }

    @Override
    public void dataCleared() {
        this.singleIntervalReport.clearData();
        this.allIntervalsReport.clearData();
        this.addBorderIfNecessary();
    }

    @Override
    public void intervalAdded(Interval interval) {
        if (this.isEnabled()) {
            this.allIntervals.setEnabled(true);
        }
    }

    @Override
    public void intervalRemoved(Interval interval) {
        if (this.gui.getIntervalManager().getIntervalCount() == 0) {
            this.intervalsCleared();
        }
    }

    @Override
    public void intervalsCleared() {
        if (this.isEnabled()) {
            this.allIntervals.setEnabled(false);
            this.allIntervals.setSelected(false);
            this.toggleReports();
        }
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
    }

    @Override
    public void intervalRenamed(Interval interval) {
    }

    private void toggleReports() {
        int location = this.getDividerLocation();
        if (this.allIntervals.isSelected()) {
            this.singleIntervalReport.setEnabled(false);
            this.allIntervalsReport.setEnabled(true);
            this.updateLastTab();
            this.setTopComponent(this.allIntervalsReport);
        } else {
            this.allIntervalsReport.setEnabled(false);
            this.singleIntervalReport.setEnabled(true);
            this.updateLastTab();
            this.setTopComponent(this.singleIntervalReport);
        }
        this.setDividerLocation(location);
        this.revalidate();
    }

    private void addBorderIfNecessary() {
        if (this.allIntervalsReport.getTabCount() == 0) {
            if (this.allIntervalsReport.getBorder() == null) {
                this.allIntervalsReport.setBorder(Styles.createTopLineBorder(this));
            }
        } else if (this.allIntervalsReport.getBorder() != null) {
            this.allIntervalsReport.setBorder(null);
        }
        if (this.singleIntervalReport.getTabCount() == 0) {
            if (this.singleIntervalReport.getBorder() == null) {
                this.singleIntervalReport.setBorder(Styles.createTopLineBorder(this));
            }
        } else if (this.singleIntervalReport.getBorder() != null) {
            this.singleIntervalReport.setBorder(null);
        }
    }

    private void updateLastTab() {
        int i;
        ReportPanel currentReport = null;
        currentReport = this.allIntervals.isSelected() ? this.singleIntervalReport : this.allIntervalsReport;
        int index = currentReport.getSelectedIndex();
        String lastTabName = null;
        if (index != -1) {
            lastTabName = currentReport.getTitleAt(index);
        }
        currentReport = this.allIntervals.isSelected() ? this.allIntervalsReport : this.singleIntervalReport;
        boolean found = false;
        if (lastTabName != null) {
            for (i = 0; i < currentReport.getTabCount(); ++i) {
                if (!currentReport.getTitleAt(i).equals(lastTabName)) continue;
                if (currentReport.getSelectedIndex() != i) {
                    currentReport.setSelectedIndex(i);
                }
                this.lastCommonTabName = lastTabName;
                found = true;
                break;
            }
        }
        if (!found) {
            for (i = 0; i < currentReport.getTabCount(); ++i) {
                if (!currentReport.getTitleAt(i).equals(this.lastCommonTabName)) continue;
                if (currentReport.getSelectedIndex() == i) break;
                currentReport.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    protected String[] getDefaultColumns() {
        return new String[]{"Series Name", "Minimum", "Average", "Maximum", "Std Dev"};
    }
}

