/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.analysis.SummaryTablePanel;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.annotate.AnnotationCache;
import com.ibm.nmon.gui.chart.annotate.AnnotationListener;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.main.ChartSplitPane;
import com.ibm.nmon.gui.main.DataSetView;
import com.ibm.nmon.gui.main.DataTypeView;
import com.ibm.nmon.gui.main.MainMenu;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.main.SummaryView;
import com.ibm.nmon.gui.tree.TreePathParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class ViewManager
extends JPanel
implements PropertyChangeListener,
TreeSelectionListener,
AnnotationListener {
    private static final long serialVersionUID = 1411425971480047253L;
    private final NMONVisualizerGui gui;
    private final SummaryView summaryView;
    private final DataSetView dataSetView;
    private final DataTypeView dataTypeView;
    private final JPanel blank;
    private final SummaryTablePanel tablePanel;
    private final PathParser pathParser;
    private TreePath currentPath;
    private ChartSplitPane currentView;
    private boolean addingAnnotation = false;
    private boolean displayedOnce = false;

    ViewManager(NMONVisualizerGui gui) {
        super(new BorderLayout());
        this.gui = gui;
        this.pathParser = new PathParser();
        this.summaryView = new SummaryView(gui);
        this.dataSetView = new DataSetView(gui);
        this.dataTypeView = new DataTypeView(gui);
        this.summaryView.addPropertyChangeListener("annotation", this);
        this.dataSetView.addPropertyChangeListener("annotation", this);
        this.dataTypeView.addPropertyChangeListener("annotation", this);
        this.summaryView.addPropertyChangeListener("chart", this);
        this.dataSetView.addPropertyChangeListener("chart", this);
        this.dataTypeView.addPropertyChangeListener("chart", this);
        this.blank = new JPanel();
        this.blank.setBackground(Color.WHITE);
        this.blank.setBorder(Styles.createTopLineBorder(this));
        this.tablePanel = new SummaryTablePanel(gui, gui.getMainFrame());
        this.tablePanel.setEnabled(false);
        gui.addPropertyChangeListener("chartsDisplayed", this);
        AnnotationCache.addAnnotationListener(this);
        this.add(this.blank);
    }

    void displayTableColumnChooser() {
        if (this.currentView != null) {
            this.currentView.displayTableColumnChooser();
        }
    }

    private void showNothing() {
        if (this.getComponent(0) != this.blank) {
            this.remove(0);
            this.add(this.blank);
            this.summaryView.setEnabled(false);
            this.dataSetView.setEnabled(false);
            this.dataTypeView.setEnabled(false);
            this.tablePanel.setEnabled(false);
            this.updateDividerLocation();
            this.currentView = null;
        }
    }

    private void showSummaryView() {
        if (this.currentView != this.summaryView) {
            this.remove(0);
            this.add(this.summaryView);
            this.summaryView.setEnabled(true);
            this.dataSetView.setEnabled(false);
            this.dataTypeView.setEnabled(false);
            this.tablePanel.setEnabled(false);
            this.updateDividerLocation();
            this.currentView = this.summaryView;
        }
    }

    private void showDataSetView() {
        if (this.currentView != this.dataSetView) {
            this.remove(0);
            this.add(this.dataSetView);
            this.summaryView.setEnabled(false);
            this.dataSetView.setEnabled(true);
            this.dataTypeView.setEnabled(false);
            this.tablePanel.setEnabled(false);
            this.updateDividerLocation();
            this.currentView = this.dataSetView;
        }
    }

    private void showDataTypeView() {
        if (this.currentView != this.dataTypeView) {
            this.remove(0);
            this.add(this.dataTypeView);
            this.summaryView.setEnabled(false);
            this.dataSetView.setEnabled(false);
            this.dataTypeView.setEnabled(true);
            this.tablePanel.setEnabled(false);
            this.updateDividerLocation();
            this.currentView = this.dataTypeView;
        }
    }

    private void showTable() {
        if (this.getComponent(0) != this.tablePanel) {
            this.remove(0);
            this.add(this.tablePanel);
            this.summaryView.setEnabled(false);
            this.dataSetView.setEnabled(false);
            this.dataTypeView.setEnabled(false);
            this.tablePanel.setEnabled(true);
            this.updateDividerLocation();
            this.currentView = null;
        }
    }

    private void updateDividerLocation() {
        if (this.currentView != null) {
            int location = this.currentView.getDividerLocation();
            this.summaryView.setDividerLocation(location);
            this.dataSetView.setDividerLocation(location);
            this.dataTypeView.setDividerLocation(location);
        }
    }

    public void saveCharts() {
        if (this.currentView != null) {
            GUIFileChooser chooser = new GUIFileChooser(this.gui, "Select Save Location");
            chooser.setFileSelectionMode(1);
            if (chooser.showDialog(this.gui.getMainFrame(), "Save") == 0) {
                String directory = chooser.getSelectedFile().getAbsolutePath();
                this.currentView.saveCharts(directory);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chartsDisplayed".equals(evt.getPropertyName())) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.pathParser.parse(this.currentPath);
            } else {
                this.showTable();
            }
        } else if ("chart".equals(evt.getPropertyName())) {
            if (AnnotationCache.hasAnnotations() && evt.getNewValue() != null) {
                this.addingAnnotation = true;
                ((BaseChartPanel)evt.getNewValue()).addAnnotations(AnnotationCache.getAnnotations());
                ((BaseChartPanel)evt.getNewValue()).addMarkers(AnnotationCache.getMarkers());
                this.addingAnnotation = false;
            }
        } else if ("annotation".equals(evt.getPropertyName()) && evt.getNewValue() != null && !this.addingAnnotation) {
            this.addingAnnotation = true;
            AnnotationCache.add(evt.getNewValue());
            this.addingAnnotation = false;
        }
    }

    @Override
    public void annotationAdded() {
        this.annotationsCleared();
    }

    @Override
    public void annotationRemoved() {
        this.annotationsCleared();
    }

    @Override
    public void annotationsCleared() {
        BaseChartPanel currentChart;
        if (!this.addingAnnotation && this.currentView != null && (currentChart = this.currentView.getChartPanel()) != null) {
            this.addingAnnotation = true;
            currentChart.addAnnotations(AnnotationCache.getAnnotations());
            currentChart.addMarkers(AnnotationCache.getMarkers());
            this.addingAnnotation = false;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.currentPath = e.getNewLeadSelectionPath();
        this.pathParser.parse(this.currentPath);
    }

    private final class PathParser
    extends TreePathParser {
        private PathParser() {
        }

        @Override
        protected void onNullPath() {
            if (ViewManager.this.gui.getBooleanProperty("chartsDisplayed")) {
                ViewManager.this.showNothing();
                this.enableChartMenu(false);
            }
        }

        @Override
        protected void onRootPath() {
            if (ViewManager.this.gui.getBooleanProperty("chartsDisplayed")) {
                if (ViewManager.this.gui.getDataSetCount() == 0) {
                    ViewManager.this.showNothing();
                } else {
                    ViewManager.this.showSummaryView();
                    this.enableChartMenu(true);
                }
            }
        }

        @Override
        protected void onDataSetPath(DataSet data) {
            ViewManager.this.dataSetView.setData(data);
            if (ViewManager.this.gui.getBooleanProperty("chartsDisplayed")) {
                ViewManager.this.showDataSetView();
                ViewManager.this.dataSetView.setEnabled(true);
                this.enableChartMenu(true);
            }
        }

        @Override
        protected void onProcessPath(DataSet data) {
            if (ViewManager.this.gui.getBooleanProperty("chartsDisplayed")) {
                ViewManager.this.showNothing();
                this.enableChartMenu(false);
            }
        }

        @Override
        protected void onTypePath(DataSet data, DataType type) {
            ViewManager.this.dataTypeView.setData(data, type);
            if (ViewManager.this.gui.getBooleanProperty("chartsDisplayed")) {
                ViewManager.this.showDataTypeView();
                this.enableChartMenu(true);
            }
        }

        @Override
        protected void onFieldPath(DataSet data, DataType type, String field) {
            ViewManager.this.dataTypeView.setData(data, type, field);
            if (ViewManager.this.gui.getBooleanProperty("chartsDisplayed")) {
                ViewManager.this.showDataTypeView();
                this.enableChartMenu(true);
            }
        }

        @Override
        protected Object onReturn(DataSet data, DataType type, String field) {
            if (!ViewManager.this.displayedOnce && ViewManager.this.currentView != null) {
                ViewManager.this.doLayout();
                ViewManager.this.currentView.setDividerLocation(0.75);
                ViewManager.this.displayedOnce = true;
            }
            ViewManager.this.repaint();
            return super.onReturn(data, type, field);
        }

        private void enableChartMenu(boolean enabled) {
            MainMenu menu = (MainMenu)ViewManager.this.gui.getMainFrame().getJMenuBar();
            menu.enableChartSubMenu(enabled);
        }
    }
}

