/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.parse;

import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.util.HostnameComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

abstract class BaseParserDialog
extends GUIDialog {
    private static final long serialVersionUID = 5488444964553569979L;
    private final JLabel parsedFileLabel;
    private final JComboBox<String> hostnames;
    private final JButton ok;
    private boolean skip = true;

    protected BaseParserDialog(NMONVisualizerGui gui, String title) {
        super(gui, gui.getMainFrame(), title);
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        HostnameComboBoxModel model = new HostnameComboBoxModel(gui);
        this.hostnames = new JComboBox<String>(model);
        this.hostnames.setEditable(true);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hostname = BaseParserDialog.this.getHostname();
                if (hostname == null || "".equals(hostname)) {
                    JOptionPane.showMessageDialog(BaseParserDialog.this, "Hostname is required", "Missing Value", 0);
                } else if (BaseParserDialog.this.validateOK()) {
                    BaseParserDialog.this.skip = false;
                    BaseParserDialog.this.beforeDispose();
                    BaseParserDialog.this.dispose();
                }
            }
        });
        JButton skip = new JButton("Skip");
        skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseParserDialog.this.skip = true;
                BaseParserDialog.this.dispose();
            }
        });
        this.parsedFileLabel = new JLabel();
        this.parsedFileLabel.setFont(Styles.TITLE);
        this.parsedFileLabel.setHorizontalAlignment(0);
        this.parsedFileLabel.setBorder(Styles.TITLE_BORDER);
        JLabel hostnameLabel = new JLabel("Hostname:");
        hostnameLabel.setFont(Styles.LABEL);
        hostnameLabel.setHorizontalAlignment(11);
        JLabel dateLabel = new JLabel("Date:");
        dateLabel.setFont(Styles.LABEL);
        dateLabel.setHorizontalAlignment(11);
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(Styles.CONTENT_BORDER);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        Insets insets = new Insets(5, 0, 0, 5);
        labelConstraints.gridx = 0;
        fieldConstraints.gridx = 1;
        labelConstraints.insets = insets;
        fieldConstraints.insets = insets;
        labelConstraints.anchor = 768;
        fieldConstraints.anchor = 512;
        labelConstraints.fill = 2;
        fieldConstraints.fill = 0;
        labelConstraints.gridy = 0;
        fieldConstraints.gridy = 0;
        content.add((Component)hostnameLabel, labelConstraints);
        content.add(this.hostnames, fieldConstraints);
        labelConstraints.gridy = 1;
        fieldConstraints.gridy = 1;
        this.addComponents(content, labelConstraints, fieldConstraints);
        JPanel temp = new JPanel();
        temp.add(this.ok);
        temp.add(skip);
        this.add((Component)this.parsedFileLabel, "First");
        this.add((Component)content, "Center");
        this.add((Component)temp, "Last");
        this.pack();
        this.setLocationRelativeTo(gui.getMainFrame());
    }

    protected void addComponents(JPanel content, GridBagConstraints labelConstraints, GridBagConstraints fieldConstraints) {
    }

    protected boolean validateOK() {
        return true;
    }

    protected void beforeDispose() {
    }

    public final void parseDataSet(String fileToParse) {
        int idx = fileToParse.lastIndexOf(47);
        if (idx != -1) {
            fileToParse = fileToParse.substring(idx + 1);
        }
        this.parsedFileLabel.setText(fileToParse);
        this.setVisible(true);
    }

    public final boolean isSkipped() {
        return this.skip;
    }

    public final String getHostname() {
        return (String)this.hostnames.getSelectedItem();
    }

    public final void setHostname(String hostname) {
        this.hostnames.setSelectedItem(hostname);
    }

    @Override
    public final void setVisible(boolean b) {
        if (b) {
            this.skip = false;
            this.hostnames.requestFocus();
            this.getRootPane().setDefaultButton(this.ok);
        }
        super.setVisible(b);
    }
}

