/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.parse;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.parse.BaseParserDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class VerboseGCPreParser
extends BaseParserDialog {
    private static final long serialVersionUID = 647178802418910814L;
    private JComboBox<String> jvmNames;

    public VerboseGCPreParser(NMONVisualizerGui gui) {
        super(gui, "Missing GC Information");
    }

    @Override
    protected void addComponents(JPanel content, GridBagConstraints labelConstraints, GridBagConstraints fieldConstraints) {
        this.jvmNames = new JComboBox();
        this.jvmNames.setEditable(true);
        JLabel nameLabel = new JLabel("JVM Name:");
        nameLabel.setFont(Styles.LABEL);
        nameLabel.setHorizontalAlignment(11);
        content.add((Component)nameLabel, labelConstraints);
        content.add(this.jvmNames, fieldConstraints);
    }

    @Override
    protected boolean validateOK() {
        String jvmName = this.getJVMName();
        if (jvmName == null || "".equals(jvmName)) {
            JOptionPane.showMessageDialog(this, "JVM Name is required", "Missing Value", 0);
            return false;
        }
        return true;
    }

    @Override
    protected void beforeDispose() {
        boolean existing = false;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.jvmNames.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!((String)model.getElementAt(i)).equals(this.jvmNames.getSelectedItem())) continue;
            existing = true;
            break;
        }
        if (!existing) {
            model.addElement((String)this.jvmNames.getSelectedItem());
        }
    }

    public String getJVMName() {
        String name = (String)this.jvmNames.getSelectedItem();
        if (name == null) {
            name = "";
        }
        return name.trim();
    }

    public void setJVMName(String jvmName) {
        this.jvmNames.setSelectedItem(jvmName);
    }
}

