/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.report;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.annotate.AnnotationCache;
import com.ibm.nmon.gui.chart.annotate.AnnotationListener;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.report.ReportMenu;
import com.ibm.nmon.gui.report.ReportPanel;
import com.ibm.nmon.gui.report.ReportSplitPane;
import com.ibm.nmon.gui.report.ReportSystemsListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportFrame
extends JFrame
implements DataSetListener,
PropertyChangeListener,
AnnotationListener {
    private static final long serialVersionUID = -2870624156130798498L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportFrame.class);
    private final NMONVisualizerGui gui;
    private ReportSplitPane reportSplitPane;
    private final JList<DataSet> systems;
    private boolean addingAnnotation = false;

    public ReportFrame(NMONVisualizerGui gui) {
        super("Custom Report");
        this.gui = gui;
        this.reportSplitPane = new ReportSplitPane(gui, this);
        this.reportSplitPane.addPropertyChangeListener(this);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setIconImage(Styles.REPORT_ICON.getImage());
        Dimension parentSize = gui.getMainFrame().getSize();
        Dimension thisSize = new Dimension((int)(parentSize.getWidth() * 0.9), (int)(parentSize.getHeight() * 0.9));
        this.setSize(thisSize);
        this.setLocationRelativeTo(gui.getMainFrame());
        if ((gui.getMainFrame().getExtendedState() & 6) == 6) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
        this.setJMenuBar(new ReportMenu(gui, this));
        ReportSystemsListModel model = new ReportSystemsListModel();
        this.systems = new JList<DataSet>(model);
        this.systems.setSelectionMode(0);
        this.systems.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -5095717717027686318L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index == 0) {
                    this.setText("All Systems");
                    this.setIcon(Styles.REPORT_ICON);
                } else {
                    this.setText(((DataSet)value).getHostname());
                    this.setIcon(Styles.COMPUTER_ICON);
                }
                this.setBorder(new EmptyBorder(2, 5, 2, 5));
                return this;
            }
        });
        this.systems.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DataSet selected = (DataSet)ReportFrame.this.systems.getModel().getElementAt(ReportFrame.this.systems.getSelectionModel().getMinSelectionIndex());
                    if (selected == null) {
                        ReportFrame.this.reportSplitPane.setData(ReportFrame.this.gui.getDataSets());
                        ReportFrame.this.enableMultiplexing(false);
                    } else {
                        ReportFrame.this.reportSplitPane.setData(Collections.singletonList(selected));
                        ReportFrame.this.enableMultiplexing(true);
                    }
                }
            }
        });
        for (DataSet dataSet : gui.getDataSets()) {
            model.addData(dataSet);
        }
        JRadioButton none = new JRadioButton("None");
        JRadioButton jRadioButton = new JRadioButton("By Type");
        JRadioButton byField = new JRadioButton("By Field");
        none.setActionCommand(ReportPanel.MultiplexMode.NONE.name());
        jRadioButton.setActionCommand(ReportPanel.MultiplexMode.BY_TYPE.name());
        byField.setActionCommand(ReportPanel.MultiplexMode.BY_FIELD.name());
        none.setFont(Styles.LABEL);
        jRadioButton.setFont(Styles.LABEL);
        byField.setFont(Styles.LABEL);
        none.setBorder(Styles.CONTENT_BORDER);
        jRadioButton.setBorder(Styles.CONTENT_BORDER);
        byField.setBorder(Styles.CONTENT_BORDER);
        ActionListener modeChanger = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportFrame.this.reportSplitPane.setMultiplexMode(ReportPanel.MultiplexMode.valueOf(e.getActionCommand()));
            }
        };
        none.addActionListener(modeChanger);
        jRadioButton.addActionListener(modeChanger);
        byField.addActionListener(modeChanger);
        none.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(none);
        group.add(jRadioButton);
        group.add(byField);
        JLabel multiplex = new JLabel("Chart Multiplexing:");
        multiplex.setFont(Styles.LABEL);
        JPanel top = new JPanel();
        top.add(multiplex);
        top.add(none);
        top.add(jRadioButton);
        top.add(byField);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)top, "First");
        right.add((Component)this.reportSplitPane, "Center");
        JSplitPane lrSplitPane = new JSplitPane(1);
        lrSplitPane.setResizeWeight(0.0);
        lrSplitPane.setBorder(null);
        lrSplitPane.setLeftComponent(this.systems);
        lrSplitPane.setRightComponent(right);
        this.setContentPane(lrSplitPane);
        this.systems.setSelectedIndex(0);
        this.enableMultiplexing(false);
        gui.addDataSetListener(this);
        AnnotationCache.addAnnotationListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ((JSplitPane)ReportFrame.this.getContentPane()).setDividerLocation(0.15);
                ReportFrame.this.reportSplitPane.setDividerLocation(0.7);
            }
        });
    }

    @Override
    public void dataAdded(DataSet data) {
        if (this.systems.getSelectedIndex() == 0) {
            this.reportSplitPane.setData(this.gui.getDataSets());
        }
        ((ReportSystemsListModel)this.systems.getModel()).addData(data);
    }

    @Override
    public void dataRemoved(DataSet data) {
        if (this.systems.getSelectedIndex() == 0) {
            this.reportSplitPane.setData(this.gui.getDataSets());
        } else if (this.systems.getSelectedValue().equals(data)) {
            this.systems.setSelectedIndex(0);
        }
        ((ReportSystemsListModel)this.systems.getModel()).removeData(data);
    }

    @Override
    public void dataChanged(DataSet data) {
        ((ReportSystemsListModel)this.systems.getModel()).dataChanged();
    }

    @Override
    public void dataCleared() {
        if (this.systems.getSelectedIndex() == 0) {
            this.reportSplitPane.setData(this.gui.getDataSets());
        } else {
            this.systems.setSelectedIndex(0);
        }
        ((ReportSystemsListModel)this.systems.getModel()).clearData();
    }

    private void enableMultiplexing(boolean enable) {
        JSplitPane lrSplitPane = (JSplitPane)this.getContentPane();
        JPanel top = (JPanel)((JPanel)lrSplitPane.getRightComponent()).getComponent(0);
        for (int i = 1; i < 4; ++i) {
            top.getComponent(i).setEnabled(enable);
        }
    }

    @Override
    public void dispose() {
        this.reportSplitPane.dispose();
        this.gui.removeDataSetListener(this);
        AnnotationCache.removeAnnoationListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chart".equals(evt.getPropertyName())) {
            if (AnnotationCache.hasAnnotations() && evt.getNewValue() != null) {
                this.addingAnnotation = true;
                ((BaseChartPanel)evt.getNewValue()).addAnnotations(AnnotationCache.getAnnotations());
                ((BaseChartPanel)evt.getNewValue()).addMarkers(AnnotationCache.getMarkers());
                this.addingAnnotation = false;
            }
        } else if ("annotation".equals(evt.getPropertyName()) && evt.getNewValue() != null) {
            this.addingAnnotation = true;
            AnnotationCache.add(evt.getNewValue());
            this.addingAnnotation = false;
        }
    }

    @Override
    public void annotationAdded() {
        this.annotationsCleared();
    }

    @Override
    public void annotationRemoved() {
        this.annotationsCleared();
    }

    @Override
    public void annotationsCleared() {
        BaseChartPanel currentChart;
        if (!this.addingAnnotation && (currentChart = this.reportSplitPane.getChartPanel()) != null) {
            this.addingAnnotation = true;
            currentChart.addAnnotations(AnnotationCache.getAnnotations());
            currentChart.addMarkers(AnnotationCache.getMarkers());
            this.addingAnnotation = false;
        }
    }

    NMONVisualizerGui getGui() {
        return this.gui;
    }

    boolean loadReportDefinition(File reportFile) {
        if (!reportFile.exists()) {
            JOptionPane.showMessageDialog(this, "File '" + reportFile.getName() + "' is not a valid file", "Invalid File", 0);
            return this.reportSplitPane.hasReport();
        }
        try {
            this.reportSplitPane.loadReport(reportFile);
            this.setTitle("Custom Report - " + reportFile.getName());
            this.configureReport();
            return true;
        }
        catch (Exception e) {
            this.setTitle("Custom Report");
            LOGGER.error("could not parse report file '{}'", (Object)reportFile.getAbsolutePath(), (Object)e);
            JOptionPane.showMessageDialog(this, "Error parsing '" + reportFile.getName() + "'\n" + e.getMessage(), "Parse Error", 0);
            return false;
        }
    }

    void loadDefaultDataSetReport() {
        this.reportSplitPane.loadDefaultDataSetReport();
        this.setTitle("Default DataSet Report");
        this.configureReport();
    }

    void loadDefaultSummaryReport() {
        this.reportSplitPane.loadDefaultSummaryReport();
        this.setTitle("Default All Systems Report");
        this.configureReport();
    }

    private void configureReport() {
        DataSet selected = this.systems.getModel().getElementAt(this.systems.getSelectionModel().getMinSelectionIndex());
        if (selected == null) {
            this.reportSplitPane.setData(this.gui.getDataSets());
        } else {
            this.reportSplitPane.setData(Collections.singletonList(selected));
        }
    }

    void saveAllCharts() {
        GUIFileChooser chooser = new GUIFileChooser(this.gui, "Select Save Location");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showDialog(this, "Save") == 0) {
            String directory = chooser.getSelectedFile().getAbsolutePath();
            this.reportSplitPane.saveCharts(directory);
        }
    }
}

