/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.report;

import com.ibm.nmon.gui.chart.annotate.AnnotationCache;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.report.ReportFileChooser;
import com.ibm.nmon.gui.report.ReportFrame;
import com.ibm.nmon.gui.util.GranularityDialog;
import com.ibm.nmon.gui.util.LogViewerDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

final class ReportMenu
extends JMenuBar {
    private static final long serialVersionUID = 2244915433441666995L;
    private final NMONVisualizerGui gui;
    private final ReportFrame parent;
    private final ReportFileChooser chooser;
    private final JMenuItem save;

    ReportMenu(NMONVisualizerGui gui, ReportFrame parent) {
        this.gui = gui;
        this.parent = parent;
        this.chooser = new ReportFileChooser(parent.getGui());
        JMenu file = new JMenu("File");
        file.setMnemonic('f');
        JMenuItem item = new JMenuItem("Load...");
        item.setMnemonic('l');
        item.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReportMenu.this.chooser.showDialog(ReportMenu.this.parent, "Parse") == 0) {
                    boolean reportLoaded = ReportMenu.this.parent.loadReportDefinition(ReportMenu.this.chooser.getSelectedFile());
                    ReportMenu.this.save.setEnabled(reportLoaded);
                }
            }
        });
        file.add(item);
        JMenu loadDefaults = new JMenu("Load Default");
        loadDefaults.setMnemonic('d');
        file.add(loadDefaults);
        item = new JMenuItem("DataSet Report");
        item.setMnemonic('d');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportMenu.this.parent.loadDefaultDataSetReport();
                ReportMenu.this.save.setEnabled(false);
            }
        });
        loadDefaults.add(item);
        item = new JMenuItem("All Systems Report");
        item.setMnemonic('a');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportMenu.this.parent.loadDefaultSummaryReport();
                ReportMenu.this.save.setEnabled(false);
            }
        });
        loadDefaults.add(item);
        this.save = new JMenuItem("Save...");
        this.save.setMnemonic('s');
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportMenu.this.parent.saveAllCharts();
            }
        });
        this.save.setEnabled(false);
        file.add(this.save);
        file.addSeparator();
        item = new JMenuItem("Close");
        item.setMnemonic('c');
        item.setAccelerator(KeyStroke.getKeyStroke(115, 128));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportMenu.this.parent.dispose();
            }
        });
        file.add(item);
        this.add(file);
        JMenu view = new JMenu("View");
        view.setMnemonic('v');
        item = new JMenuItem("Set Granularity...");
        item.setMnemonic('g');
        item.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new GranularityDialog(ReportMenu.this.gui, ReportMenu.this.parent).setVisible(true);
            }
        });
        view.add(item);
        view.addSeparator();
        item = new JMenuItem("Clear Annotations");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationCache.clear();
            }
        });
        view.add(item);
        item = new JMenuItem("Remove Last Line");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationCache.removeLastMarker();
            }
        });
        view.add(item);
        item = new JMenuItem("Remove Last Text");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationCache.removeLastAnnotation();
            }
        });
        view.add(item);
        this.add(view);
        JMenu help = new JMenu("Help");
        help.setMnemonic('h');
        item = new JMenuItem("View Log...");
        item.setMnemonic('l');
        item.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        item.setIcon(LogViewerDialog.LOG_ICON);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ReportMenu.this.gui.getLogViewer().isVisible()) {
                    ReportMenu.this.gui.getLogViewer().setVisible(true);
                } else {
                    ReportMenu.this.gui.getLogViewer().toFront();
                }
                ReportMenu.this.gui.getLogViewer().setLocationRelativeTo(ReportMenu.this.parent);
            }
        });
        help.add(item);
        this.add(help);
    }
}

