/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.report;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.chart.definition.BarChartDefinition;
import com.ibm.nmon.chart.definition.BaseChartDefinition;
import com.ibm.nmon.chart.definition.HistogramChartDefinition;
import com.ibm.nmon.chart.definition.IntervalChartDefinition;
import com.ibm.nmon.chart.definition.LineChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.BarChartPanel;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.ChartFactory;
import com.ibm.nmon.gui.chart.IntervalChartPanel;
import com.ibm.nmon.gui.chart.LineChartPanel;
import com.ibm.nmon.gui.chart.builder.ChartBuilderPlugin;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.util.ItemProgressDialog;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportPanel
extends JTabbedPane
implements PropertyChangeListener,
IntervalListener {
    private static final long serialVersionUID = 6377401207979477789L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPanel.class);
    private final NMONVisualizerGui gui;
    private final JFrame parent;
    private final List<DataSet> dataSets;
    private final String reportCacheKey;
    private MultiplexMode multiplexMode;
    private List<BaseChartDefinition> chartsInUse;
    private BitSet chartNeedsUpdate;
    private final ChartFactory chartFactory;
    private boolean buildingTabs;
    private int previousTab = -1;

    public ReportPanel(NMONVisualizerGui gui, String reportCacheKey, DataSet data) {
        this(gui, gui.getMainFrame(), reportCacheKey, Collections.singletonList(data), MultiplexMode.NONE);
    }

    public ReportPanel(NMONVisualizerGui gui, String reportCacheKey) {
        this(gui, gui.getMainFrame(), reportCacheKey, new ArrayList<DataSet>(), MultiplexMode.NONE);
    }

    public ReportPanel(NMONVisualizerGui gui, JFrame parent, String reportCacheKey, List<DataSet> dataSets, MultiplexMode multiplexMode) {
        this.chartFactory = new ChartFactory(gui);
        this.chartFactory.setGranularity(gui.getGranularity());
        this.gui = gui;
        this.parent = parent;
        this.dataSets = dataSets;
        this.reportCacheKey = reportCacheKey;
        this.multiplexMode = multiplexMode;
        this.chartsInUse = Collections.emptyList();
        this.buildTabs(gui);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int idx;
                if (!ReportPanel.this.buildingTabs && (idx = ReportPanel.this.getSelectedIndex()) != -1) {
                    if (!ReportPanel.this.updateChart()) {
                        ReportPanel.this.firePropertyChange("chart", null, ReportPanel.this.getChartPanel(idx));
                    }
                    if (ReportPanel.this.previousTab != -1 && ReportPanel.this.previousTab < ReportPanel.this.getTabCount()) {
                        ReportPanel.this.getChartPanel(ReportPanel.this.previousTab).setEnabled(false);
                    }
                    ReportPanel.this.getChartPanel(idx).setEnabled(true);
                    ReportPanel.this.previousTab = idx;
                }
            }
        });
        this.setEnabled(false);
        gui.getIntervalManager().addListener(this);
        gui.addPropertyChangeListener("granularity", this);
        gui.addPropertyChangeListener("timeZone", this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            if (this.chartsInUse != null && !this.chartsInUse.isEmpty()) {
                int idx = this.getSelectedIndex();
                if (enabled) {
                    if (idx != -1 && !this.updateChart()) {
                        this.firePropertyChange("chart", null, this.getChartPanel(idx));
                    }
                } else if (idx != -1) {
                    this.getChartPanel().clearChart();
                    this.chartNeedsUpdate.set(idx);
                }
                if (idx != -1) {
                    this.getChartPanel(idx).setEnabled(enabled);
                    this.previousTab = idx;
                }
            }
        }
    }

    public MultiplexMode getMultiplexMode() {
        return this.multiplexMode;
    }

    public void setMultiplexMode(MultiplexMode multiplexMode) {
        if (multiplexMode == null) {
            multiplexMode = MultiplexMode.NONE;
        }
        if (this.multiplexMode != multiplexMode) {
            this.multiplexMode = multiplexMode;
            this.buildTabs(this.gui);
            this.resetReport();
        }
    }

    public void setData(Iterable<? extends DataSet> dataSets) {
        this.dataSets.clear();
        for (DataSet dataSet : dataSets) {
            this.dataSets.add(dataSet);
        }
        Collections.sort(this.dataSets);
        this.buildTabs(this.gui);
        this.resetReport();
    }

    public void addData(DataSet data) {
        if (!this.dataSets.contains(data)) {
            this.dataSets.add(data);
            Collections.sort(this.dataSets);
            this.buildTabs(this.gui);
            this.resetReport();
        }
    }

    public void removeData(DataSet data) {
        if (this.dataSets.remove(data)) {
            Collections.sort(this.dataSets);
            this.buildTabs(this.gui);
            this.resetReport();
        }
    }

    public void clearData() {
        this.dataSets.clear();
        this.buildTabs(this.gui);
        this.resetReport();
    }

    public void resetReport() {
        if (this.chartNeedsUpdate != null) {
            this.chartNeedsUpdate.set(0, this.chartNeedsUpdate.size(), true);
        }
        this.updateChart();
    }

    private boolean updateChart() {
        int index;
        if (this.isEnabled() && this.getTabCount() != 0 && (index = this.getSelectedIndex()) >= 0 && !this.chartsInUse.isEmpty()) {
            BaseChartPanel chartPanel = this.getChartPanel(index);
            if (this.chartNeedsUpdate.get(index)) {
                if (this.dataSets.isEmpty()) {
                    chartPanel.clearChart();
                } else {
                    this.createChart(index);
                }
                this.chartNeedsUpdate.clear(index);
                return true;
            }
        }
        return false;
    }

    public BaseChartPanel getChartPanel() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getChartPanel(index);
    }

    private BaseChartPanel getChartPanel(int index) {
        return (BaseChartPanel)((Object)this.getComponentAt(index));
    }

    public int getPreviousTab() {
        return this.previousTab;
    }

    public void addPlugin(ChartBuilderPlugin plugin) {
        this.chartFactory.addPlugin(plugin);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chart".equals(evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        } else if ("granularity".equals(evt.getPropertyName())) {
            int newGranularity = (Integer)evt.getNewValue();
            this.chartFactory.setGranularity(newGranularity);
            for (int i = 0; i < this.chartsInUse.size(); ++i) {
                BaseChartDefinition chartDefinition = this.chartsInUse.get(i);
                if (chartDefinition.getClass().equals(IntervalChartDefinition.class) || chartDefinition.getClass().equals(BarChartDefinition.class)) {
                    for (DataDefinition definition : chartDefinition.getData()) {
                        if (definition.getStatistic() != Statistic.GRANULARITY_MAXIMUM) continue;
                        this.chartNeedsUpdate.set(i);
                        break;
                    }
                } else {
                    this.chartNeedsUpdate.set(i);
                }
                this.updateChart();
            }
        } else if ("annotation".equals(evt.getPropertyName())) {
            if (this.chartNeedsUpdate != null) {
                this.chartNeedsUpdate.set(0, this.chartNeedsUpdate.size(), true);
                this.chartNeedsUpdate.flip(this.getSelectedIndex());
            }
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().startsWith("highlighted")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        } else if ("timeZone".equals(evt.getPropertyName())) {
            this.updateIntervalCharts();
        }
    }

    @Override
    public void intervalAdded(Interval interval) {
        this.updateIntervalCharts();
    }

    @Override
    public void intervalRemoved(Interval interval) {
        this.updateIntervalCharts();
    }

    @Override
    public void intervalsCleared() {
        this.updateIntervalCharts();
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        this.chartFactory.setInterval(interval);
        for (int i = 0; i < this.chartsInUse.size(); ++i) {
            if (this.chartsInUse.get(i).getClass().equals(IntervalChartDefinition.class)) continue;
            this.chartNeedsUpdate.set(i);
        }
        this.updateChart();
    }

    @Override
    public void intervalRenamed(Interval interval) {
        this.updateIntervalCharts();
    }

    @Override
    public void removeAll() {
        if (!this.chartsInUse.isEmpty()) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                BaseChartPanel chartPanel = this.getChartPanel(i);
                chartPanel.setEnabled(false);
                chartPanel.clearChart();
                chartPanel.removePropertyChangeListener(this);
            }
        }
        super.removeAll();
        this.chartsInUse = Collections.emptyList();
    }

    public void dispose() {
        this.gui.getIntervalManager().removeListener(this);
        this.gui.removePropertyChangeListener("granularity", this);
        this.gui.removePropertyChangeListener("timeZone", this);
        this.removeAll();
    }

    private void updateIntervalCharts() {
        for (int i = 0; i < this.chartsInUse.size(); ++i) {
            if (!this.chartsInUse.get(i).getClass().equals(IntervalChartDefinition.class)) continue;
            this.chartNeedsUpdate.set(i);
        }
        this.updateChart();
    }

    private void buildTabs(NMONVisualizerGui gui) {
        this.buildingTabs = true;
        this.removeAll();
        if (gui.getReportCache().getReport(this.reportCacheKey).isEmpty()) {
            this.addTab("No Charts", this.createNoReportsLabel("No Charts Defined!"));
        } else {
            if (this.dataSets.isEmpty()) {
                this.addTab("No Charts", this.createNoReportsLabel("No Parsed Data!"));
                this.buildingTabs = false;
                return;
            }
            if (this.multiplexMode == MultiplexMode.NONE) {
                this.chartsInUse = gui.getReportCache().getReport(this.reportCacheKey, this.dataSets);
            } else if (this.dataSets.size() > 1) {
                LOGGER.warn("not multiplexing charts when there is more than one dataset");
                this.chartsInUse = gui.getReportCache().getReport(this.reportCacheKey, this.dataSets);
            } else if (this.multiplexMode == MultiplexMode.BY_TYPE) {
                this.chartsInUse = gui.getReportCache().multiplexChartsAcrossTypes(this.reportCacheKey, this.dataSets.get(0), true);
            } else if (this.multiplexMode == MultiplexMode.BY_FIELD) {
                this.chartsInUse = gui.getReportCache().multiplexChartsAcrossFields(this.reportCacheKey, this.dataSets.get(0), true);
            }
            if (this.chartsInUse.isEmpty()) {
                this.addTab("No Charts", this.createNoReportsLabel("No Charts for Currently Parsed Data!"));
                this.chartsInUse = Collections.emptyList();
                this.chartNeedsUpdate = null;
            } else {
                this.chartNeedsUpdate = new BitSet(this.chartsInUse.size());
                this.chartNeedsUpdate.set(0, this.chartNeedsUpdate.size(), true);
                for (BaseChartDefinition report : this.chartsInUse) {
                    BaseChartPanel chartPanel = null;
                    if (report.getClass() == LineChartDefinition.class) {
                        if (report.getTitle().equals("CPU Utilization by Process") && !gui.getBooleanProperty("scaleProcessesByCPUs")) {
                            ((LineChartDefinition)report).setUsePercentYAxis(false);
                        }
                        chartPanel = new LineChartPanel(gui, this.parent);
                    } else if (report.getClass() == IntervalChartDefinition.class) {
                        chartPanel = new IntervalChartPanel(gui, this.parent);
                    } else if (report.getClass() == BarChartDefinition.class) {
                        chartPanel = new BarChartPanel(gui, this.parent);
                    } else if (report.getClass() == HistogramChartDefinition.class) {
                        chartPanel = new LineChartPanel(gui, this.parent);
                    } else {
                        LOGGER.error("cannot create chart panel for {} ({})", (Object)report.getShortName(), (Object)report.getClass().getSimpleName());
                    }
                    chartPanel.addPropertyChangeListener(this);
                    this.addTab(report.getShortName(), (Component)((Object)chartPanel));
                }
            }
        }
        if (this.previousTab > this.getTabCount()) {
            this.previousTab = -1;
        }
        this.buildingTabs = false;
    }

    private void createChart(int index) {
        BaseChartDefinition definition = this.chartsInUse.get(index);
        JFreeChart chart = this.chartFactory.createChart(definition, this.dataSets);
        BaseChartPanel chartPanel = this.getChartPanel(index);
        chartPanel.setSaveSize(definition.getWidth(), definition.getHeight());
        chartPanel.setChart(chart);
    }

    public void saveAllCharts(final String directory) {
        final ItemProgressDialog progress = new ItemProgressDialog(this.parent, "Saving Charts...", this.getTabCount());
        if (this.getTabCount() == 1 && this.getComponentAt(0) instanceof JLabel) {
            return;
        }
        Thread saver = new Thread(new Runnable(){

            @Override
            public void run() {
                final int originalTab = ReportPanel.this.getSelectedIndex();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progress.setVisible(true);
                    }
                });
                for (int i = 0; i < ReportPanel.this.getTabCount(); ++i) {
                    final String finalName = ((BaseChartDefinition)ReportPanel.this.chartsInUse.get(i)).getShortName();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progress.setCurrentItem(finalName);
                        }
                    });
                    final int n = i;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ReportPanel.this.setSelectedIndex(n);
                                ReportPanel.this.getChartPanel(n).saveChart(directory, finalName);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.warn("error saving chart " + finalName, (Throwable)e);
                        continue;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progress.updateProgress();
                        }
                    });
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ReportPanel.this.setSelectedIndex(originalTab);
                            progress.dispose();
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.warn("error closing progress dialog", (Throwable)e);
                }
            }
        });
        saver.start();
    }

    private JLabel createNoReportsLabel(String toDisplay) {
        JLabel label = new JLabel(toDisplay);
        label.setFont(Styles.LABEL_ERROR.deriveFont((float)Styles.LABEL_ERROR.getSize() * 1.5f));
        label.setHorizontalAlignment(0);
        label.setBackground(Color.WHITE);
        label.setForeground(Styles.ERROR_COLOR);
        label.setOpaque(true);
        return label;
    }

    public static enum MultiplexMode {
        NONE,
        BY_TYPE,
        BY_FIELD;

    }
}

