/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.report;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.main.ChartSplitPane;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.report.ReportPanel;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

final class ReportSplitPane
extends ChartSplitPane {
    private static final long serialVersionUID = -8401367823499645439L;
    private final JFrame parent;
    private final JPanel blank;
    private ReportPanel reportPanel;
    private ReportPanel.MultiplexMode multiplexMode;

    ReportSplitPane(NMONVisualizerGui gui, JFrame parent) {
        super(gui, parent);
        this.parent = parent;
        this.multiplexMode = ReportPanel.MultiplexMode.NONE;
        this.blank = new JPanel();
        this.blank.setBackground(Color.WHITE);
        this.blank.setBorder(Styles.createTopLineBorder(this.blank));
        this.setTopComponent(this.blank);
    }

    boolean hasReport() {
        return this.getTopComponent() != this.blank;
    }

    void loadReport(File reportFile) throws IOException {
        this.gui.getReportCache().addReport("custom", reportFile.getAbsolutePath());
        this.createReportPanel("custom");
    }

    void loadDefaultDataSetReport() {
        this.createReportPanel("dataset");
    }

    void loadDefaultSummaryReport() {
        this.createReportPanel("summary");
    }

    private void createReportPanel(String cacheKey) {
        this.setTopComponent(null);
        this.dispose();
        int location = this.getDividerLocation();
        this.reportPanel = new ReportPanel(this.gui, this.parent, cacheKey, new ArrayList<DataSet>(), this.multiplexMode);
        this.setTopComponent(this.reportPanel);
        this.reportPanel.addPropertyChangeListener("chart", this.summaryTable);
        this.reportPanel.addPropertyChangeListener("highlightedLine", this);
        this.reportPanel.addPropertyChangeListener("highlightedBar", this);
        this.reportPanel.addPropertyChangeListener("chart", this);
        this.reportPanel.addPropertyChangeListener("annotation", this);
        this.reportPanel.setEnabled(true);
        this.setDividerLocation(location);
    }

    void setData(Iterable<? extends DataSet> dataSets) {
        if (this.reportPanel != null) {
            this.reportPanel.setData(dataSets);
        }
    }

    void setMultiplexMode(ReportPanel.MultiplexMode multiplexMode) {
        if (this.reportPanel != null) {
            this.reportPanel.setMultiplexMode(multiplexMode);
        }
    }

    @Override
    public void dataAdded(DataSet data) {
    }

    @Override
    public void dataRemoved(DataSet data) {
    }

    @Override
    public void dataChanged(DataSet data) {
    }

    @Override
    public void dataCleared() {
    }

    void dispose() {
        if (this.reportPanel != null) {
            this.reportPanel.dispose();
            this.reportPanel = null;
        }
    }

    @Override
    protected BaseChartPanel getChartPanel() {
        return this.reportPanel == null ? null : this.reportPanel.getChartPanel();
    }

    @Override
    protected void saveCharts(String directory) {
        if (this.reportPanel != null) {
            this.reportPanel.saveAllCharts(directory);
        }
    }

    @Override
    protected String[] getDefaultColumns() {
        return new String[]{"Hostname", "Data Type", "Metric", "Series Name", "Minimum", "Average", "Maximum", "Std Dev"};
    }
}

