/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.table;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChoosableColumnTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 9081831820888671224L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BitSet enabledColumns;
    protected Map<String, Integer> columnNamesMap;

    public abstract String[] getAllColumns();

    public abstract boolean getDefaultColumnState(int var1);

    public abstract boolean canDisableColumn(int var1);

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public final int getColumnCount() {
        return this.enabledColumns.cardinality();
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        int n = 0;
        int i = this.enabledColumns.nextSetBit(0);
        while (i >= 0) {
            if (n == columnIndex) {
                return this.getEnabledColumnClass(i);
            }
            ++n;
            i = this.enabledColumns.nextSetBit(i + 1);
        }
        throw new ArrayIndexOutOfBoundsException(columnIndex);
    }

    protected abstract Class<?> getEnabledColumnClass(int var1);

    @Override
    public final String getColumnName(int column) {
        int n = 0;
        int i = this.enabledColumns.nextSetBit(0);
        while (i >= 0) {
            if (n == column) {
                return this.getEnabledColumnName(i);
            }
            ++n;
            i = this.enabledColumns.nextSetBit(i + 1);
        }
        throw new ArrayIndexOutOfBoundsException(column);
    }

    protected abstract String getEnabledColumnName(int var1);

    @Override
    public final Object getValueAt(int row, int column) {
        int n = 0;
        int i = this.enabledColumns.nextSetBit(0);
        while (i >= 0) {
            if (n == column) {
                return this.getEnabledValueAt(row, i);
            }
            ++n;
            i = this.enabledColumns.nextSetBit(i + 1);
        }
        throw new ArrayIndexOutOfBoundsException(column);
    }

    protected abstract Object getEnabledValueAt(int var1, int var2);

    public final boolean getEnabled(String columnName) {
        Integer idx = this.columnNamesMap.get(columnName);
        if (idx != null) {
            return this.enabledColumns.get(idx);
        }
        return false;
    }

    public final void setEnabled(String columnName, boolean enabled) {
        Integer idx = this.columnNamesMap.get(columnName);
        if (idx != null && this.enabledColumns.get(idx) != enabled) {
            this.logger.trace("{} enabled={}", (Object)columnName, (Object)enabled);
            this.enabledColumns.set((int)idx, enabled);
            if (enabled) {
                this.onEnable(columnName, idx);
            } else {
                this.onDisable(columnName, idx);
            }
            this.fireTableStructureChanged();
        }
    }

    protected void onEnable(String columnName, int column) {
    }

    protected void onDisable(String columnName, int column) {
    }

    protected void buildColumnNameMap() {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        String[] columnNames = this.getAllColumns();
        for (int i = 0; i < columnNames.length; ++i) {
            temp.put(columnNames[i], i);
        }
        this.columnNamesMap = Collections.unmodifiableMap(temp);
    }

    public int getColumnIndex(String name) {
        Integer idx = this.columnNamesMap.get(name);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    public int getEnabledColumnIndex(String name) {
        Integer idx = this.columnNamesMap.get(name);
        if (idx == null) {
            return -1;
        }
        if (!this.enabledColumns.get(idx)) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < idx; ++i) {
            if (!this.enabledColumns.get(i)) continue;
            ++n;
        }
        return n;
    }
}

