/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.table;

import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.ChoosableColumnTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public final class TableColumnChooser
extends GUIDialog {
    private static final long serialVersionUID = -9173600303234433460L;
    private final ChoosableColumnTableModel tableModel;
    private final AbstractAction allAction = new AbstractAction(){
        private static final long serialVersionUID = 5118961708188081301L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = TableColumnChooser.this.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                model.setValueAt(true, i, 1);
            }
        }
    };
    private final AbstractAction noneAction = new AbstractAction(){
        private static final long serialVersionUID = -6547510475096869295L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = TableColumnChooser.this.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!TableColumnChooser.this.tableModel.canDisableColumn(i)) continue;
                model.setValueAt(false, i, 1);
            }
        }
    };
    private final AbstractAction defaultsAction = new AbstractAction(){
        private static final long serialVersionUID = -826694390009398839L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = TableColumnChooser.this.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                model.setValueAt(TableColumnChooser.this.tableModel.getDefaultColumnState(i), i, 1);
            }
        }
    };

    public TableColumnChooser(NMONVisualizerGui gui, JFrame parent, ChoosableColumnTableModel choosableTableModel) {
        super(gui, parent, "Select Columns");
        this.setModal(true);
        this.setIconImage(Styles.buildIcon("table.png").getImage());
        this.setLayout(new BorderLayout());
        this.tableModel = choosableTableModel;
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 947165395586168365L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1 && TableColumnChooser.this.tableModel.canDisableColumn(row);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 1) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        model.addColumn("Column");
        model.addColumn("Display?");
        for (String columnName : this.tableModel.getAllColumns()) {
            model.addRow(new Object[]{columnName, this.tableModel.getEnabled(columnName)});
        }
        GUITable table = new GUITable(gui, model);
        table.getColumnModel().getColumn(0).setMinWidth(100);
        table.getColumnModel().getColumn(1).setMaxWidth(60);
        table.setDefaultRenderer(Boolean.class, new CheckBoxCellRenderer());
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().setPreferredSize(new Dimension(200, 150));
        scrollPane.setBorder(Styles.DOUBLE_LINE_BORDER);
        this.add((Component)scrollPane, "Center");
        JButton all = new JButton("All");
        all.addActionListener(this.allAction);
        JButton none = new JButton("None");
        none.setIcon(Styles.CLEAR_ICON);
        none.addActionListener(this.noneAction);
        JButton defaults = new JButton("Default");
        defaults.addActionListener(this.defaultsAction);
        JPanel temp = new JPanel();
        temp.add(all);
        temp.add(none);
        temp.add(defaults);
        this.add((Component)temp, "First");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTableModel model = TableColumnChooser.this.getModel();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    TableColumnChooser.this.tableModel.setEnabled((String)model.getValueAt(i, 0), (Boolean)model.getValueAt(i, 1));
                }
                TableColumnChooser.this.dispose();
            }
        });
        temp = new JPanel();
        temp.add(ok);
        this.add((Component)temp, "Last");
        this.getRootPane().setDefaultButton(ok);
        JPanel content = (JPanel)this.getContentPane();
        ActionMap actions = content.getActionMap();
        InputMap inputs = content.getInputMap(2);
        actions.put("all", this.allAction);
        actions.put("none", this.noneAction);
        actions.put("defaults", this.defaultsAction);
        inputs.put(KeyStroke.getKeyStroke(65, 128), "all");
        inputs.put(KeyStroke.getKeyStroke(88, 128), "none");
        inputs.put(KeyStroke.getKeyStroke(68, 128), "defaults");
        this.setVisible(true);
    }

    private final DefaultTableModel getModel() {
        return (DefaultTableModel)((GUITable)((JScrollPane)this.getContentPane().getComponent(0)).getViewport().getComponent(0)).getModel();
    }

    private final class CheckBoxCellRenderer
    implements TableCellRenderer {
        private CheckBoxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent renderer = null;
            boolean red = false;
            if (!TableColumnChooser.this.tableModel.canDisableColumn(row)) {
                JLabel required = new JLabel("Required");
                required.setHorizontalAlignment(0);
                if (!isSelected) {
                    red = true;
                }
                renderer = required;
            } else {
                Boolean b = (Boolean)value;
                JCheckBox checkBox = new JCheckBox();
                checkBox.setHorizontalAlignment(0);
                if (b != null) {
                    checkBox.setSelected(b);
                }
                renderer = checkBox;
            }
            JLabel other = (JLabel)table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color bg = other.getBackground();
            if (isSelected) {
                renderer.setForeground(table.getSelectionForeground());
                renderer.setBackground(table.getSelectionBackground());
            } else {
                renderer.setForeground(red ? Color.RED : other.getForeground());
                renderer.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            }
            renderer.setOpaque(true);
            return renderer;
        }
    }
}

