/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.time;

import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.time.SystemTimeTableCellRenderer;
import com.ibm.nmon.gui.time.SystemTimeTableModel;
import com.ibm.nmon.interval.Interval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class SystemTimeList
extends JPanel
implements HierarchyListener,
PropertyChangeListener {
    private static final long serialVersionUID = -7601601214911823159L;
    private final NMONVisualizerGui gui;
    private final GUITable systemTimes;
    private final SystemTimeTableCellRenderer renderer;
    private final Color defaultTableColor;

    public SystemTimeList(NMONVisualizerGui gui) {
        super(new BorderLayout());
        this.gui = gui;
        this.renderer = new SystemTimeTableCellRenderer();
        this.renderer.setIntervalToCompare(gui.getIntervalManager().getCurrentInterval());
        SystemTimeTableModel model = new SystemTimeTableModel(gui);
        this.systemTimes = new GUITable(gui, model);
        this.systemTimes.setSelectionMode(0);
        this.systemTimes.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.systemTimes.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.systemTimes.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.systemTimes.getColumnModel().getColumn(3).setPreferredWidth(75);
        this.systemTimes.setDefaultRenderer(String.class, this.renderer);
        this.systemTimes.setDefaultRenderer(Long.class, this.renderer);
        this.systemTimes.setDefaultRenderer(Integer.class, this.renderer);
        JLabel label = new JLabel("System Times");
        label.setFont(Styles.LABEL);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 0));
        this.add((Component)label, "First");
        JScrollPane scrollPane = new JScrollPane(this.systemTimes);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setPreferredSize(new Dimension(600, 250));
        scrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.add((Component)scrollPane, "Center");
        this.defaultTableColor = this.systemTimes.getBackground();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            if (e.getChanged().isVisible()) {
                this.gui.addPropertyChangeListener("timeZone", this);
                this.gui.addDataSetListener((SystemTimeTableModel)this.systemTimes.getModel());
            } else {
                this.gui.removePropertyChangeListener("timeZone", this);
                this.gui.removeDataSetListener((SystemTimeTableModel)this.systemTimes.getModel());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("interval".equals(evt.getPropertyName())) {
            SystemTimeTableModel model = (SystemTimeTableModel)this.systemTimes.getModel();
            Interval i = (Interval)evt.getNewValue();
            if (i != null) {
                if (!this.systemTimes.isEnabled()) {
                    this.systemTimes.setBackground(this.defaultTableColor);
                    this.systemTimes.setEnabled(true);
                    int row = this.systemTimes.getSelectedRow();
                    if (row != -1) {
                        this.systemTimes.setRowSelectionInterval(row, row);
                    }
                }
                if (!model.getCountInterval().equals(i)) {
                    this.renderer.setIntervalToCompare(i);
                    model.setCountInterval(i);
                }
            } else if (this.systemTimes.isEnabled()) {
                this.systemTimes.setEnabled(false);
                this.systemTimes.setBackground(Color.LIGHT_GRAY);
            }
        }
    }

    public GUITable getTable() {
        return this.systemTimes;
    }
}

