/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.time;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.util.TimeFormatCache;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

final class SystemTimeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 4392809910722437137L;
    private Interval toCompare;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column == 0) {
            this.setHorizontalAlignment(11);
        } else if (column == 1) {
            long intervalStart;
            long start = (Long)value;
            if (start == (intervalStart = this.toCompare.getStart())) {
                this.setFont(Styles.BOLD_ITALIC);
            } else if (intervalStart < start) {
                if (this.toCompare.getEnd() < start) {
                    this.setFont(Styles.STRIKETHROUGH);
                } else {
                    this.setFont(Styles.BOLD);
                }
            } else {
                long end = (Long)table.getValueAt(row, column + 1);
                if (intervalStart > end) {
                    this.setFont(Styles.STRIKETHROUGH);
                }
            }
            this.setText(TimeFormatCache.formatDateTime(start));
        } else if (column == 2) {
            long intervalEnd;
            long end = (Long)value;
            if (end == (intervalEnd = this.toCompare.getEnd())) {
                this.setFont(Styles.BOLD_ITALIC);
            } else if (intervalEnd > end) {
                if (this.toCompare.getStart() > end) {
                    this.setFont(Styles.STRIKETHROUGH);
                } else {
                    this.setFont(Styles.BOLD);
                }
            } else {
                long start = (Long)table.getValueAt(row, column - 1);
                if (intervalEnd < start) {
                    this.setFont(Styles.STRIKETHROUGH);
                }
            }
            this.setText(TimeFormatCache.formatDateTime(end));
        } else if (column == 3) {
            this.setHorizontalAlignment(0);
        }
        return this;
    }

    public void setIntervalToCompare(Interval toCompare) {
        this.toCompare = toCompare;
    }
}

