/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.time;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public final class SystemTimeTableModel
extends AbstractTableModel
implements DataSetListener {
    private static final long serialVersionUID = -8130932048768878945L;
    private final NMONVisualizerGui gui;
    private Interval countInterval;
    private List<Integer> counts;

    public SystemTimeTableModel(NMONVisualizerGui gui) {
        this.gui = gui;
        this.countInterval = gui.getIntervalManager().getCurrentInterval();
        this.updateCounts();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return Long.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        throw new ArrayIndexOutOfBoundsException(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "System";
            }
            case 1: {
                return "Data Start";
            }
            case 2: {
                return "Data End";
            }
            case 3: {
                return "Record Count";
            }
        }
        throw new ArrayIndexOutOfBoundsException(column);
    }

    @Override
    public int getRowCount() {
        return this.gui.getDataSetCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DataSet data = null;
        int n = 0;
        for (DataSet dataSet : this.gui.getDataSets()) {
            if (n++ != rowIndex) continue;
            data = dataSet;
            break;
        }
        if (data == null) {
            throw new ArrayIndexOutOfBoundsException(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return data.getHostname();
            }
            case 1: {
                return data.getStartTime();
            }
            case 2: {
                return data.getEndTime();
            }
            case 3: {
                return this.counts.get(rowIndex);
            }
        }
        throw new ArrayIndexOutOfBoundsException(columnIndex);
    }

    public DataSet getValueAt(int rowIndex) {
        int n = 0;
        for (DataSet dataSet : this.gui.getDataSets()) {
            if (n++ != rowIndex) continue;
            return dataSet;
        }
        throw new ArrayIndexOutOfBoundsException(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void dataAdded(DataSet data) {
        this.updateCounts();
        this.fireTableDataChanged();
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.updateCounts();
        this.fireTableDataChanged();
    }

    @Override
    public void dataChanged(DataSet data) {
        this.updateCounts();
        this.fireTableDataChanged();
    }

    @Override
    public void dataCleared() {
        this.updateCounts();
        this.fireTableDataChanged();
    }

    public Interval getCountInterval() {
        return this.countInterval;
    }

    public void setCountInterval(Interval countInterval) {
        if (!this.countInterval.equals(countInterval)) {
            this.countInterval = countInterval;
            this.updateCounts();
            this.fireTableDataChanged();
        }
    }

    private void updateCounts() {
        this.counts = new ArrayList<Integer>(this.gui.getDataSetCount());
        for (DataSet dataSet : this.gui.getDataSets()) {
            if (Interval.DEFAULT.equals(this.countInterval)) {
                this.counts.add(dataSet.getRecordCount());
                continue;
            }
            this.counts.add(dataSet.getRecordCount(this.countInterval));
        }
    }
}

