/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.tree;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.gui.Styles;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

final class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -2417103407578950522L;
    private static final ImageIcon DATATYPE_ICON = Styles.buildIcon("package.png");
    private static final ImageIcon DATASUBTYPE_ICON = Styles.buildIcon("package_green.png");
    private static final ImageIcon FIELD_ICON = Styles.buildIcon("page.png");
    private static final ImageIcon PROCESS_ICON = Styles.buildIcon("cog.png");

    TreeCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object o = ((DefaultMutableTreeNode)value).getUserObject();
        if (o instanceof DataSet) {
            this.setIcon(Styles.COMPUTER_ICON);
            this.setToolTipText(null);
        } else if (o instanceof DataType) {
            this.setIcon(DATATYPE_ICON);
            this.setToolTipText(((DataType)o).getName());
        } else if (o instanceof Process) {
            this.setIcon(PROCESS_ICON);
            String commandLine = ((Process)o).getCommandLine();
            if (commandLine.length() > 0) {
                if (commandLine.length() > 100) {
                    commandLine = commandLine.substring(0, 50) + " ... " + commandLine.substring(commandLine.length() - 50);
                }
                this.setToolTipText(commandLine);
            } else {
                this.setToolTipText(((Process)o).getName());
            }
        } else if (o instanceof String) {
            String s = (String)o;
            if (s.equals("All Systems")) {
                this.setIcon(Styles.REPORT_ICON);
                this.setToolTipText(null);
            } else if (s.equals("TOP")) {
                this.setIcon(DATASUBTYPE_ICON);
                this.setToolTipText("Top Processes");
            } else if (s.equals("Process")) {
                this.setIcon(DATASUBTYPE_ICON);
                this.setToolTipText("Processes");
            } else if (s.equals("GC")) {
                this.setIcon(DATASUBTYPE_ICON);
                this.setToolTipText("Garbage Collection");
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent();
                if (parent.getUserObject() instanceof DataSet) {
                    this.setIcon(DATASUBTYPE_ICON);
                    this.setToolTipText(s);
                } else {
                    String p = parent.toString();
                    if (p.equals("TOP")) {
                        this.setIcon(DATATYPE_ICON);
                    }
                    if (p.equals("Process")) {
                        this.setIcon(DATATYPE_ICON);
                    } else if (p.equals("GC")) {
                        this.setIcon(DATATYPE_ICON);
                    } else {
                        this.setIcon(FIELD_ICON);
                    }
                    this.setToolTipText(null);
                }
            }
        }
        return this;
    }
}

