/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.tree;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.gui.data.MergeDataSetDialog;
import com.ibm.nmon.gui.data.RemoveAllDataSetsAction;
import com.ibm.nmon.gui.file.CSVFileChooser;
import com.ibm.nmon.gui.file.FileLoadAction;
import com.ibm.nmon.gui.info.MetadataInfoDialog;
import com.ibm.nmon.gui.info.ProcessInfoDialog;
import com.ibm.nmon.gui.info.SystemInfoDialog;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.tree.TreePathParser;
import com.ibm.nmon.util.CSVWriter;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

final class TreeMouseListener
extends TreePathParser
implements MouseListener {
    protected final NMONVisualizerGui gui;
    protected final JTree tree;
    protected MouseEvent event;
    private final ActionListener saveChartsAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeMouseListener.this.gui.getViewManager().saveCharts();
        }
    };

    protected TreeMouseListener(NMONVisualizerGui gui, JTree tree) {
        this.gui = gui;
        this.tree = tree;
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int row = this.tree.getClosestRowForLocation(e.getX(), e.getY());
            TreePath selectionPath = null;
            if (row != -1 && this.tree.getRowBounds(row).getMaxY() >= (double)e.getY()) {
                selectionPath = this.tree.getPathForRow(row);
            }
            if (selectionPath != null) {
                this.tree.setSelectionPath(selectionPath);
            }
            this.event = e;
            this.parse(selectionPath);
            this.event = null;
        }
    }

    @Override
    protected final void onNullPath() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Load Files..");
        item.addActionListener(new FileLoadAction(this.gui));
        menu.add(item);
        item = new JMenuItem("Remove All");
        item.addActionListener(new RemoveAllDataSetsAction(this.gui, this.gui.getMainFrame()));
        menu.add(item);
        menu.show(this.event.getComponent(), this.event.getX(), this.event.getY());
    }

    @Override
    protected void onRootPath() {
        if (this.gui.getDataSetCount() > 0) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Save Summary Charts...");
            item.addActionListener(this.saveChartsAction);
            menu.add(item);
            menu.show(this.event.getComponent(), this.event.getX(), this.event.getY());
        }
    }

    @Override
    protected final void onDataSetPath(DataSet data) {
        this.buildDataSetMenu(data).show(this.event.getComponent(), this.event.getX(), this.event.getY());
    }

    @Override
    protected void onTypePath(DataSet data, DataType type) {
        this.buildTypeMenu(data, type, type.getFields()).show(this.event.getComponent(), this.event.getX(), this.event.getY());
    }

    @Override
    protected void onFieldPath(DataSet data, DataType type, String field) {
        this.buildTypeMenu(data, type, Collections.singletonList(field)).show(this.event.getComponent(), this.event.getX(), this.event.getY());
    }

    private JPopupMenu buildDataSetMenu(final DataSet data) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Save to CSV...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CSVFileChooser(TreeMouseListener.this.gui, data, null, null).saveToCSV();
            }
        });
        menu.add(item);
        item = new JMenuItem("Save Charts...");
        item.addActionListener(this.saveChartsAction);
        menu.add(item);
        menu.addSeparator();
        if (data.getClass().equals(SystemDataSet.class)) {
            SystemDataSet systemData = (SystemDataSet)data;
            boolean needsSeparator = false;
            if (systemData.getMetadataCount() > 0) {
                item = new JMenuItem("Parsed File Info");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new MetadataInfoDialog(TreeMouseListener.this.gui, (SystemDataSet)data).setVisible(true);
                    }
                });
                menu.add(item);
                needsSeparator = true;
            }
            if (systemData.getSystemInfoCount() > 0) {
                item = new JMenuItem("System Info");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new SystemInfoDialog(TreeMouseListener.this.gui, (SystemDataSet)data).setVisible(true);
                    }
                });
                menu.add(item);
                needsSeparator = true;
            }
            if (needsSeparator) {
                menu.addSeparator();
            }
            item = new JMenuItem("Merge...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new MergeDataSetDialog(TreeMouseListener.this.gui, (SystemDataSet)data).setVisible(true);
                }
            });
            menu.add(item);
        }
        item = new JMenuItem("Remove");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeMouseListener.this.gui.removeDataSet(data);
            }
        });
        menu.add(item);
        return menu;
    }

    private JPopupMenu buildTypeMenu(final DataSet data, final DataType type, final List<String> fields) {
        ProcessDataType processType;
        JPopupMenu menu = new JPopupMenu();
        if (type.getClass().equals(ProcessDataType.class) && (processType = (ProcessDataType)type).getProcess().getId() != -1) {
            JMenuItem item = new JMenuItem("Process Info");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ProcessInfoDialog(TreeMouseListener.this.gui, TreeMouseListener.this.tree, processType.getProcess()).setVisible(true);
                }
            });
            menu.add(item);
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Copy");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringWriter writer = new StringWriter(4096);
                try {
                    CSVWriter.write(data, type, fields, TreeMouseListener.this.gui.getIntervalManager().getCurrentInterval(), (Writer)writer);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
                TreeMouseListener.this.gui.getMainFrame().getToolkit().getSystemClipboard().setContents(new StringSelection(writer.toString()), null);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save to CSV...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CSVFileChooser(TreeMouseListener.this.gui, data, type, fields).saveToCSV();
            }
        });
        menu.add(item);
        item = new JMenuItem("Save Chart...");
        item.addActionListener(this.saveChartsAction);
        menu.add(item);
        return menu;
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }
}

