/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.tree;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.gui.dnd.TreeTransferHandler;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.tree.TreeCellRenderer;
import com.ibm.nmon.gui.tree.TreeMouseListener;
import com.ibm.nmon.util.DataHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreePanel
extends JScrollPane
implements DataSetListener {
    private static final long serialVersionUID = 8763622839346467286L;
    static final String ROOT_NAME = "All Systems";
    protected final JTree tree;

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.tree.addTreeSelectionListener(tsl);
    }

    public TreePanel(NMONVisualizerGui gui) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ROOT_NAME);
        this.tree = new JTree(root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.setViewportView(this.tree);
        this.setBorder(null);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        gui.addDataSetListener(this);
        this.tree.addMouseListener(new TreeMouseListener(gui, this.tree));
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new TreeTransferHandler(gui));
        this.tree.setCellRenderer(new TreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    @Override
    public final void dataAdded(DataSet data) {
        DefaultMutableTreeNode dataNode = null;
        TreePath selectedPath = null;
        List<Object> expandedPaths = null;
        boolean existing = false;
        int insertIdx = 0;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultTreeModel)this.tree.getModel()).getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            Enumeration<TreePath> temp;
            DefaultMutableTreeNode toSearch = (DefaultMutableTreeNode)root.getChildAt(i);
            DataSet currentData = (DataSet)toSearch.getUserObject();
            if (data.toString().compareTo(currentData.toString()) > 0) {
                insertIdx = i + 1;
            }
            if (!currentData.equals(data)) continue;
            dataNode = toSearch;
            existing = true;
            TreePath current = this.tree.getSelectionPath();
            if (current != null && new TreePath(dataNode.getPath()).isDescendant(current)) {
                selectedPath = current;
            }
            expandedPaths = (temp = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()))) != null ? Collections.list(temp) : Collections.emptyList();
            dataNode.removeAllChildren();
            break;
        }
        if (dataNode == null) {
            dataNode = new DefaultMutableTreeNode(data);
        }
        this.buildDataSetTree(dataNode, data);
        if (existing) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(dataNode);
            for (TreePath path : expandedPaths) {
                this.tree.expandPath(this.rebuildPath(path));
            }
            if (selectedPath != null) {
                this.tree.setSelectionPath(this.rebuildPath(selectedPath));
            }
        } else {
            if (insertIdx > root.getChildCount()) {
                insertIdx = root.getChildCount() - 1;
            }
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(dataNode, root, insertIdx);
            if (root.getChildCount() == 1) {
                this.tree.expandRow(0);
            }
            if ((selectedPath = this.tree.getSelectionPath()) == null || selectedPath.getLastPathComponent() == root) {
                this.tree.setSelectionPath(null);
                this.tree.setSelectionPath(new TreePath(root));
            }
        }
    }

    @Override
    public final void dataRemoved(DataSet data) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultTreeModel)this.tree.getModel()).getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DataSet toSearch = (DataSet)((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject();
            if (!toSearch.equals(data)) continue;
            TreeNode removed = root.getChildAt(i);
            root.remove(i);
            ((DefaultTreeModel)this.tree.getModel()).nodesWereRemoved(root, new int[]{i}, new Object[]{removed});
            this.tree.setSelectionPath(new TreePath(root));
            break;
        }
    }

    @Override
    public void dataChanged(DataSet data) {
        this.dataAdded(data);
    }

    @Override
    public final void dataCleared() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultTreeModel)this.tree.getModel()).getRoot();
        boolean pathSelected = false;
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            pathSelected = true;
        }
        root.removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).reload();
        if (pathSelected) {
            this.tree.setSelectionPath(new TreePath(root));
        }
    }

    private TreePath rebuildPath(TreePath oldPath) {
        DefaultMutableTreeNode parent;
        Object[] oldPaths = oldPath.getPath();
        Object[] newPath = new DefaultMutableTreeNode[oldPaths.length];
        newPath[0] = parent = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        int pathIdx = 1;
        block0: while (parent != null && pathIdx < newPath.length) {
            ArrayList<TreeNode> children = Collections.list(parent.children());
            for (DefaultMutableTreeNode defaultMutableTreeNode : children) {
                if (!((DefaultMutableTreeNode)oldPaths[pathIdx]).getUserObject().equals(defaultMutableTreeNode.getUserObject())) continue;
                newPath[pathIdx] = defaultMutableTreeNode;
                ++pathIdx;
                parent = defaultMutableTreeNode;
                continue block0;
            }
        }
        return new TreePath(newPath);
    }

    private void buildDataSetTree(DefaultMutableTreeNode dataNode, DataSet data) {
        boolean buildProcessNode = false;
        ArrayList<SubDataType> gcTypes = null;
        HashMap<String, DefaultMutableTreeNode> subtypes = null;
        for (DataType type : data.getTypes()) {
            if (type.getClass().equals(SubDataType.class)) {
                SubDataType subtype;
                String id;
                DefaultMutableTreeNode typeNode;
                if (type.getId().startsWith("GC")) {
                    if (gcTypes == null) {
                        gcTypes = new ArrayList<SubDataType>();
                    }
                    gcTypes.add((SubDataType)type);
                    continue;
                }
                if (subtypes == null) {
                    subtypes = new HashMap<String, DefaultMutableTreeNode>();
                }
                if ((typeNode = (DefaultMutableTreeNode)subtypes.get(id = (subtype = (SubDataType)type).getPrimaryId())) == null) {
                    typeNode = new DefaultMutableTreeNode(id);
                    subtypes.put(id, typeNode);
                    dataNode.add(typeNode);
                }
                typeNode.add(new TypeTreeNode(subtype, true));
                continue;
            }
            if (type.getClass().equals(ProcessDataType.class)) {
                buildProcessNode = true;
                continue;
            }
            dataNode.add(new TypeTreeNode(type));
        }
        if (buildProcessNode) {
            dataNode.add(this.buildTopTree((ProcessDataSet)data));
        }
        if (gcTypes != null) {
            dataNode.add(this.buildGCTree(gcTypes));
        }
    }

    private DefaultMutableTreeNode buildTopTree(ProcessDataSet data) {
        DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(data.getTypeIdPrefix());
        Map<String, List<Process>> processNameToProcesses = DataHelper.getProcessesByName(data, true);
        for (String processName : processNameToProcesses.keySet()) {
            List<Process> processes = processNameToProcesses.get(processName);
            DefaultMutableTreeNode processNode = null;
            if (processes.size() > 1) {
                processNode = new DefaultMutableTreeNode(processes.get(0).getName());
                ArrayList<ProcessDataType> types = new ArrayList<ProcessDataType>();
                for (Process process : processes) {
                    DefaultMutableTreeNode processInstance = new DefaultMutableTreeNode(process);
                    ProcessDataType type = data.getType(process);
                    types.add(type);
                    for (String field : type.getFields()) {
                        processInstance.add(new DefaultMutableTreeNode(field));
                    }
                    processNode.add(processInstance);
                }
            } else {
                processNode = new DefaultMutableTreeNode(processes.get(0));
                for (String field : data.getType(processes.get(0)).getFields()) {
                    processNode.add(new DefaultMutableTreeNode(field));
                }
            }
            topNode.add(processNode);
        }
        return topNode;
    }

    private DefaultMutableTreeNode buildGCTree(List<SubDataType> gcTypes) {
        DefaultMutableTreeNode gcNode = new DefaultMutableTreeNode("GC");
        HashMap<String, DefaultMutableTreeNode> jvmNodes = new HashMap<String, DefaultMutableTreeNode>();
        for (SubDataType type : gcTypes) {
            String jvmName = type.getSubId();
            DefaultMutableTreeNode jvmNode = (DefaultMutableTreeNode)jvmNodes.get(jvmName);
            if (jvmNode == null) {
                jvmNode = new DefaultMutableTreeNode(jvmName);
                gcNode.add(jvmNode);
                jvmNodes.put(jvmName, jvmNode);
            }
            jvmNode.add(new TypeTreeNode(type, false));
        }
        return gcNode;
    }

    private final class TypeTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -3704741016840510282L;
        private final String toDisplay;

        TypeTreeNode(DataType type) {
            super(type);
            this.toDisplay = type.getId();
            for (String field : type.getFields()) {
                this.add(new DefaultMutableTreeNode(field));
            }
        }

        TypeTreeNode(SubDataType type, boolean showSubId) {
            super(type);
            this.toDisplay = showSubId ? type.getSubId() : type.getPrimaryId();
            for (String field : type.getFields()) {
                this.add(new DefaultMutableTreeNode(field));
            }
        }

        @Override
        public String toString() {
            return this.toDisplay;
        }
    }
}

