/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.tree;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.SystemDataSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class TreePathParser {
    public final Object parse(TreePath path) {
        Object o;
        if (path == null) {
            this.onNullPath();
            return this.onReturn(null, null, null);
        }
        Object[] paths = path.getPath();
        if (paths.length == 0) {
            this.onNullPath();
            return this.onReturn(null, null, null);
        }
        if (paths.length == 1) {
            this.onRootPath();
            return this.onReturn(null, null, null);
        }
        SystemDataSet data = (SystemDataSet)((DefaultMutableTreeNode)paths[1]).getUserObject();
        if (paths.length == 2) {
            this.onDataSetPath(data);
            return this.onReturn(data, null, null);
        }
        DataType type = null;
        String field = null;
        if (paths.length > 2 && !(o = ((DefaultMutableTreeNode)paths[2]).getUserObject()).getClass().equals(String.class)) {
            type = (DataType)o;
        }
        if (paths.length > 3) {
            o = ((DefaultMutableTreeNode)paths[3]).getUserObject();
            if (o.getClass().equals(Process.class)) {
                type = data.getType((Process)o);
            } else if (o.getClass().equals(String.class)) {
                field = (String)o;
            } else {
                type = (DataType)o;
            }
        }
        if (paths.length > 4) {
            field = null;
            o = ((DefaultMutableTreeNode)paths[4]).getUserObject();
            if (o.getClass().equals(Process.class)) {
                type = data.getType((Process)o);
            } else if (o instanceof DataType) {
                type = (DataType)o;
            } else {
                field = (String)o;
            }
        }
        if (paths.length > 5) {
            o = ((DefaultMutableTreeNode)paths[5]).getUserObject();
            field = (String)o;
        }
        if (type == null) {
            this.onProcessPath(data);
        } else if (field == null) {
            this.onTypePath(data, type);
        } else {
            this.onFieldPath(data, type, field);
        }
        return this.onReturn(data, type, field);
    }

    protected void onNullPath() {
    }

    protected void onRootPath() {
    }

    protected void onDataSetPath(DataSet data) {
    }

    protected void onTypePath(DataSet data, DataType type) {
    }

    protected void onProcessPath(DataSet data) {
    }

    protected void onFieldPath(DataSet data, DataType type, String field) {
    }

    protected Object onReturn(DataSet data, DataType type, String field) {
        return null;
    }
}

