/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.util;

import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public final class GranularityDialog
extends GUIDialog {
    private static final long serialVersionUID = 3006930761856999987L;
    private final JCheckBox automatic;
    private final JTextField granularity;
    private final JButton ok;

    public GranularityDialog(NMONVisualizerGui gui, JFrame parent) {
        super(gui, parent, " Granularity?");
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.automatic = new JCheckBox();
        this.automatic.setHorizontalAlignment(11);
        this.automatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GranularityDialog.this.granularity.setEnabled(!GranularityDialog.this.automatic.isSelected());
                if (GranularityDialog.this.granularity.isEnabled()) {
                    GranularityDialog.this.granularity.requestFocus();
                    GranularityDialog.this.granularity.selectAll();
                }
            }
        });
        this.automatic.setSelected(gui.getBooleanProperty("automaticGranularity"));
        this.granularity = new JTextField(Integer.toString(gui.getGranularity() / 1000));
        this.granularity.setEnabled(!this.automatic.isSelected());
        this.granularity.setColumns(3);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newGranularity = -1;
                if (!GranularityDialog.this.automatic.isSelected()) {
                    try {
                        newGranularity = Integer.parseInt(GranularityDialog.this.granularity.getText()) * 1000;
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(GranularityDialog.this.gui.getMainFrame(), "Granularity must be a whole number!", "Granularity", 0);
                        return;
                    }
                    if (newGranularity < 1) {
                        JOptionPane.showMessageDialog(GranularityDialog.this.gui.getMainFrame(), "Granularity must be greater than 0!", "Granularity", 0);
                        return;
                    }
                }
                GranularityDialog.this.gui.setGranularity(newGranularity);
                GranularityDialog.this.dispose();
            }
        });
        JLabel icon = new JLabel((Icon)UIManager.get("OptionPane.questionIcon"));
        icon.setVerticalAlignment(1);
        icon.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 25));
        this.add((Component)icon, "Before");
        JPanel temp = new JPanel();
        temp.add(this.ok);
        this.add((Component)temp, "Last");
        JLabel autoLabel = new JLabel("Automatic:");
        autoLabel.setFont(Styles.LABEL);
        autoLabel.setHorizontalAlignment(11);
        JLabel granularityLabel = new JLabel("Granularity:");
        granularityLabel.setFont(Styles.LABEL);
        granularityLabel.setHorizontalAlignment(11);
        JLabel seconds = new JLabel("sec");
        seconds.setFont(Styles.LABEL);
        JPanel options = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 0, 0, 2);
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 512;
        options.add((Component)autoLabel, constraints);
        constraints.gridx = 1;
        constraints.anchor = 10;
        options.add((Component)this.automatic, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.anchor = 768;
        options.add((Component)granularityLabel, constraints);
        constraints.gridx = 1;
        constraints.anchor = 512;
        options.add((Component)this.granularity, constraints);
        constraints.gridx = 2;
        constraints.insets = new Insets(5, 0, 0, 5);
        options.add((Component)seconds, constraints);
        this.add((Component)options, "Center");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this.ok);
            if (this.granularity.isEnabled()) {
                this.granularity.requestFocus();
                this.granularity.selectAll();
            }
        }
        super.setVisible(b);
    }
}

