/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.util;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public final class HostnameComboBoxModel
extends AbstractListModel<String>
implements ComboBoxModel<String>,
DataSetListener {
    private static final long serialVersionUID = 6370252527474683605L;
    private final List<String> hosts = new LinkedList<String>();
    private String selected = null;

    public HostnameComboBoxModel(NMONVisualizerGui gui) {
        for (DataSet dataSet : gui.getDataSets()) {
            this.addHostname(dataSet.getHostname());
        }
        if (gui.getDataSetCount() == 1) {
            this.setSelectedItem(this.hosts.get(0));
        }
        gui.addDataSetListener(this);
    }

    @Override
    public String getElementAt(int index) {
        return this.hosts.get(index);
    }

    @Override
    public int getSize() {
        return this.hosts.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        String item = (String)anItem;
        this.selected = item = item.trim();
        if (!"".equals(item) && !this.hosts.contains(this.selected)) {
            this.addHostname(this.selected);
        }
    }

    @Override
    public void dataAdded(DataSet data) {
        String hostname = data.getHostname();
        this.addHostname(hostname);
    }

    private void addHostname(String hostname) {
        for (int i = 0; i < this.hosts.size(); ++i) {
            if (this.hosts.get(i).equals(hostname)) {
                return;
            }
            if (this.hosts.get(i).compareTo(hostname) <= 0) continue;
            this.hosts.add(i, hostname);
            this.fireIntervalAdded(this, i, i);
            return;
        }
        this.hosts.add(hostname);
        this.fireIntervalAdded(this, 0, 0);
    }

    @Override
    public void dataRemoved(DataSet data) {
        String hostname = data.getHostname();
        for (int i = 0; i < this.hosts.size(); ++i) {
            if (!this.hosts.get(i).equals(hostname)) continue;
            this.hosts.remove(i);
            this.fireIntervalRemoved(this, i, i);
            return;
        }
    }

    @Override
    public void dataChanged(DataSet data) {
    }

    @Override
    public void dataCleared() {
        this.hosts.clear();
        this.fireContentsChanged(this, 1, Integer.MAX_VALUE);
    }
}

