/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.util;

import com.ibm.nmon.gui.Styles;
import java.awt.Component;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public final class ItemProgressDialog
extends JDialog {
    private static final long serialVersionUID = -7316137795169235117L;
    private final JFrame parent;
    private final JLabel itemName;
    private final JProgressBar progress;
    private final int totalItems;
    private int itemCount;
    private static final String DUMMY = new String(new byte[40]);

    public ItemProgressDialog(JFrame parent, String title, int totalItems) {
        super(parent, title, true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.parent = parent;
        this.totalItems = totalItems;
        this.itemCount = 0;
        this.progress = new JProgressBar(0, totalItems);
        this.progress.setStringPainted(true);
        this.progress.setFont(Styles.LABEL);
        this.progress.setString(this.itemCount + " / " + totalItems);
        this.progress.setValue(this.itemCount);
        this.itemName = new JLabel(DUMMY);
        this.itemName.setFont(Styles.TITLE);
        this.itemName.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 5));
        this.add((Component)this.progress, "Center");
        this.add((Component)this.itemName, "First");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
            Point location = this.parent.getLocation();
            this.setLocation(location.x + this.parent.getWidth() / 2 - this.getWidth() / 2, location.y + this.parent.getHeight() / 2 - this.getHeight() * 2);
        }
        super.setVisible(b);
    }

    public void setCurrentItem(String name) {
        this.itemName.setText(name);
    }

    public void updateProgress() {
        this.progress.setValue(++this.itemCount);
        this.progress.setString(this.itemCount + " / " + this.totalItems);
    }
}

