/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.util;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.util.BasicFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class LogViewerDialog
extends JFrame {
    private static final long serialVersionUID = 2036301168126084250L;
    public static final ImageIcon LOG_ICON = Styles.buildIcon("page_error.png");
    private final JComboBox<Level> levels;
    private final JTextArea log;

    public LogViewerDialog(NMONVisualizerGui gui) {
        super("Application Log");
        this.setResizable(true);
        this.setIconImage(LOG_ICON.getImage());
        this.setDefaultCloseOperation(1);
        this.log = new JTextArea();
        this.log.setColumns(100);
        this.log.setRows(30);
        this.log.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.log);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setBorder(Styles.DOUBLE_LINE_BORDER);
        JLabel logLevel = new JLabel("Log Level:");
        logLevel.setFont(Styles.LABEL);
        this.levels = new JComboBox<Level>(new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINEST, Level.OFF});
        this.levels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Logger.getLogger("com.ibm.nmon").setLevel((Level)e.getItem());
            }
        });
        AbstractAction clearAction = new AbstractAction(){
            private static final long serialVersionUID = 2136102234176694095L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LogViewerDialog.this.log.setText("");
            }
        };
        JButton clear = new JButton("Clear");
        clear.setIcon(Styles.CLEAR_ICON);
        clear.addActionListener(clearAction);
        JButton copyAll = new JButton("Copy All");
        copyAll.setIcon(Styles.COPY_ICON);
        copyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogViewerDialog.this.log.selectAll();
                LogViewerDialog.this.log.getTransferHandler().exportToClipboard(LogViewerDialog.this.log, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            }
        });
        ((JComponent)this.getComponent(0)).getActionMap().put("clear", clearAction);
        ((JComponent)this.getComponent(0)).getInputMap(2).put(KeyStroke.getKeyStroke(127, 128), "clear");
        JPanel header = new JPanel();
        header.add(logLevel);
        header.add(this.levels);
        JPanel footer = new JPanel(new BorderLayout());
        JPanel temp = new JPanel();
        temp.add(clear);
        footer.add((Component)temp, "Center");
        temp = new JPanel();
        temp.add(copyAll);
        footer.add((Component)temp, "Before");
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(copyAll.getPreferredSize());
        temp = new JPanel();
        temp.add(spacer);
        footer.add((Component)temp, "After");
        this.add((Component)header, "First");
        this.add((Component)scroller, "Center");
        this.add((Component)footer, "Last");
        this.pack();
        this.configureLogging();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = super.createRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 5405906817147819455L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LogViewerDialog.this.setVisible(false);
            }
        });
        return rootPane;
    }

    private void configureLogging() {
        Logger root = Logger.getLogger("");
        this.levels.setSelectedItem(root.getLevel());
        for (Handler handler : root.getHandlers()) {
            root.removeHandler(handler);
        }
        root.addHandler(new LogHandler());
    }

    private class QueuedLog
    implements Runnable {
        private final String toLog;

        QueuedLog(String toLog) {
            this.toLog = toLog;
        }

        @Override
        public void run() {
            LogViewerDialog.this.log.append(this.toLog);
        }
    }

    private class LogHandler
    extends Handler {
        LogHandler() {
            this.setFormatter(new BasicFormatter());
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                SwingUtilities.invokeLater(new QueuedLog(this.getFormatter().format(record)));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

