/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.util;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public final class ScrollingTableFix
implements ComponentListener {
    private final JTable table;

    public ScrollingTableFix(JTable table, JScrollPane scrollPane) {
        assert (table != null);
        this.table = table;
        table.getModel().addTableModelListener(new ColumnAddFix(table, scrollPane));
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentResized(ComponentEvent event) {
        if ((double)event.getComponent().getWidth() < this.table.getPreferredSize().getWidth()) {
            this.table.setAutoResizeMode(0);
        } else {
            this.table.setAutoResizeMode(4);
        }
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    private static final class ColumnAddFix
    implements TableModelListener {
        private final JTable table;
        private final JScrollPane scrollPane;

        ColumnAddFix(JTable table, JScrollPane scrollPane) {
            this.table = table;
            this.scrollPane = scrollPane;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getFirstRow() == -1) {
                if ((double)this.scrollPane.getViewport().getWidth() < this.table.getPreferredSize().getWidth()) {
                    this.table.setAutoResizeMode(0);
                } else {
                    this.table.setAutoResizeMode(4);
                }
            }
        }
    }
}

