/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.interval;

public final class Interval
implements Comparable<Interval> {
    public static final Interval DEFAULT = new Interval(0L, Long.MAX_VALUE);
    private String name = "";
    private final long start;
    private final long end;

    public Interval(long start, long end) {
        this.start = start;
        this.end = end;
        this.validate();
    }

    private void validate() {
        if (this.start >= this.end) {
            throw new IllegalArgumentException("end must be greater than start");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getDuration() {
        return this.end - this.start;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Interval) {
            Interval i = (Interval)obj;
            return this.start == i.start && this.end == i.end;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.start ^ this.start >>> 32) * 31 + (int)(this.end ^ this.end >>> 32);
    }

    @Override
    public int compareTo(Interval i) {
        if (this.start == i.start) {
            if (this.end == i.end) {
                return 0;
            }
            return this.end > i.end ? 1 : -1;
        }
        return this.start > i.start ? 1 : -1;
    }
}

