/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.interval;

import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import com.ibm.nmon.util.DataHelper;
import com.ibm.nmon.util.TimeFormatCache;
import com.ibm.nmon.util.TimeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntervalManager.class);
    private final Set<Interval> intervals;
    private Interval currentInterval;
    private List<IntervalListener> listeners = new CopyOnWriteArrayList<IntervalListener>();
    private static final Pattern DATA_SPLITTER = Pattern.compile("\"?,\"?");

    public IntervalManager() {
        this.intervals = new TreeSet<Interval>();
        this.currentInterval = Interval.DEFAULT;
    }

    public Interval getCurrentInterval() {
        return this.currentInterval;
    }

    public void setCurrentInterval(Interval interval) {
        block4: {
            block3: {
                if (!this.intervals.contains(interval)) break block3;
                if (this.currentInterval.equals(interval)) break block4;
                LOGGER.debug("setting current interval to {}", (Object)TimeFormatCache.formatInterval(interval));
                this.currentInterval = interval;
                for (IntervalListener listener : this.listeners) {
                    listener.currentIntervalChanged(interval);
                }
                break block4;
            }
            if (Interval.DEFAULT.equals(interval)) {
                LOGGER.debug("setting current interval to {}", (Object)"DEFAULT");
                this.currentInterval = Interval.DEFAULT;
                for (IntervalListener listener : this.listeners) {
                    listener.currentIntervalChanged(interval);
                }
            }
        }
    }

    public Iterable<Interval> getIntervals() {
        return Collections.unmodifiableSet(this.intervals);
    }

    public int getIntervalCount() {
        return this.intervals.size();
    }

    public boolean addInterval(Interval interval) {
        if (Interval.DEFAULT.equals(interval)) {
            LOGGER.trace("not adding DEFAULT interval");
            return false;
        }
        if (this.intervals.add(interval)) {
            LOGGER.debug("added interval {}", (Object)TimeFormatCache.formatInterval(interval));
            for (IntervalListener listener : this.listeners) {
                listener.intervalAdded(interval);
            }
            return true;
        }
        LOGGER.trace("interval {} already present", (Object)TimeFormatCache.formatInterval(interval));
        return false;
    }

    public boolean removeInterval(Interval interval) {
        if (this.intervals.remove(interval)) {
            LOGGER.debug("removed interval {}", (Object)TimeFormatCache.formatInterval(interval));
            for (IntervalListener listener : this.listeners) {
                listener.intervalRemoved(interval);
            }
            if (this.currentInterval.equals(interval)) {
                LOGGER.trace("setting current interval to {}", (Object)"DEFAULT");
                this.setCurrentInterval(Interval.DEFAULT);
            }
            return true;
        }
        return false;
    }

    public void clearIntervals() {
        this.intervals.clear();
        LOGGER.debug("intervals cleared");
        for (IntervalListener listener : this.listeners) {
            listener.intervalsCleared();
        }
        this.setCurrentInterval(Interval.DEFAULT);
    }

    public void renameInterval(Interval interval, String newName) {
        if (this.intervals.contains(interval)) {
            if (newName == null) {
                newName = "";
            }
            if (!interval.getName().equals(newName)) {
                interval.setName(newName);
                TimeFormatCache.renameInterval(interval);
                for (IntervalListener listener : this.listeners) {
                    listener.intervalRenamed(interval);
                }
            }
        }
    }

    public void addListener(IntervalListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IntervalListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file, long offset) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file));
            String line = null;
            Interval interval = null;
            block21: while ((line = ((LineNumberReader)reader).readLine()) != null) {
                String[] data = DATA_SPLITTER.split(line);
                String name = "";
                String start = "";
                String end = "";
                switch (data.length) {
                    case 0: {
                        LOGGER.trace("skipping empty interval data at line {}", (Object)((LineNumberReader)reader).getLineNumber());
                        continue block21;
                    }
                    case 1: {
                        LOGGER.trace("skipping empty interval data at line {}", (Object)((LineNumberReader)reader).getLineNumber());
                        continue block21;
                    }
                    case 2: {
                        start = data[0];
                        end = data[1];
                        break;
                    }
                    case 3: {
                        name = DataHelper.newString(data[0]);
                        start = data[1];
                        end = data[2];
                        break;
                    }
                    default: {
                        continue block21;
                    }
                }
                long startTime = 0L;
                long endTime = 0L;
                try {
                    startTime = TimeHelper.TIMESTAMP_FORMAT_ISO.parse(start).getTime();
                }
                catch (ParseException pe) {
                    try {
                        startTime = Long.parseLong(start) + offset;
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.warn("cannot parse time {} at line {}", (Object)startTime, (Object)((LineNumberReader)reader).getLineNumber());
                        continue;
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("line {}: {}={}", new Object[]{((LineNumberReader)reader).getLineNumber(), startTime, start});
                }
                try {
                    endTime = TimeHelper.TIMESTAMP_FORMAT_ISO.parse(end).getTime();
                }
                catch (ParseException pe) {
                    try {
                        endTime = Long.parseLong(end) + offset;
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.warn("cannot parse time {} at line {}", (Object)startTime, (Object)((LineNumberReader)reader).getLineNumber());
                        continue;
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("line {}: {}={}", new Object[]{((LineNumberReader)reader).getLineNumber(), endTime, end});
                }
                interval = new Interval(startTime, endTime);
                interval.setName(name);
                this.addInterval(interval);
            }
            if (interval != null) {
                this.setCurrentInterval(interval);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file, long offset) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            for (Interval interval : this.getIntervals()) {
                long start = interval.getStart() - offset;
                long end = interval.getEnd() - offset;
                writer.write(interval.getName());
                writer.write(44);
                if (offset == 0L) {
                    writer.write(TimeHelper.TIMESTAMP_FORMAT_ISO.format(new Date(start)));
                    writer.write(44);
                    writer.write(TimeHelper.TIMESTAMP_FORMAT_ISO.format(new Date(end)));
                } else {
                    writer.write(Long.toString(start));
                    writer.write(44);
                    writer.write(Long.toString(end));
                }
                writer.write(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe2) {}
            }
        }
    }
}

