/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser;

import com.ibm.nmon.parser.util.XMLParserHelper;
import com.ibm.nmon.util.DataHelper;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicXMLParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LineNumberReader in;
    protected boolean skip = false;

    protected final void parse(String filename) throws IOException {
        this.in = new LineNumberReader(new FileReader(filename));
        this.parse();
    }

    protected final void parse(InputStream stream) throws IOException {
        this.in = new LineNumberReader(new InputStreamReader(stream));
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        try {
            String line = null;
            boolean valid = false;
            for (int i = 0; i < 10; ++i) {
                line = this.in.readLine();
                if (line == null) {
                    throw new IllegalArgumentException("file ended before <?xml> tag");
                }
                if (!line.contains("<?xml")) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new IllegalArgumentException("file contains no <?xml> tag in the first 10 lines ");
            }
            line = this.in.readLine();
            int searchStart = 0;
            while (line != null) {
                int elementEnd;
                int elementStart = line.indexOf(60, searchStart) + 1;
                if (elementStart == 0) {
                    line = this.in.readLine();
                    searchStart = 0;
                    continue;
                }
                char c = line.charAt(elementStart);
                if (c == '!') {
                    elementEnd = line.lastIndexOf(62);
                    if (elementEnd == -1) {
                        line = line + this.in.readLine();
                        continue;
                    }
                    if (line.charAt(elementEnd - 1) == '-') {
                        line = this.in.readLine();
                        searchStart = 0;
                        continue;
                    }
                    line = line + this.in.readLine();
                    continue;
                }
                elementEnd = line.indexOf(62, elementStart);
                if (elementEnd == -1) {
                    line = line + this.in.readLine();
                    continue;
                }
                boolean start = true;
                boolean end = false;
                int nameStart = elementStart;
                if (c == '/') {
                    start = false;
                    end = true;
                    ++nameStart;
                }
                if (nameStart == elementEnd) {
                    this.logger.warn("ignoring unnamed element at line {}", (Object)this.getLineNumber());
                    searchStart = elementEnd + 1;
                    continue;
                }
                int nameEnd = line.indexOf(32, nameStart);
                if (line.charAt(elementEnd - 1) == '/') {
                    end = true;
                    if (nameEnd == -1) {
                        nameEnd = elementEnd - 1;
                    }
                } else if (nameEnd == -1) {
                    nameEnd = elementEnd;
                }
                String name = DataHelper.newString(line.substring(nameStart, nameEnd));
                if (start) {
                    String unparsedAttributes = line.substring(nameEnd, elementEnd);
                    this.logger.trace("start element '{}' with attributes '{}'", (Object)name, (Object)unparsedAttributes);
                    this.startElement(name, unparsedAttributes);
                }
                if (end) {
                    this.logger.trace("end element '{}'", (Object)name);
                    this.endElement(name);
                }
                if (elementEnd == line.length() - 1) {
                    line = this.in.readLine();
                    searchStart = 0;
                    continue;
                }
                searchStart = elementEnd + 1;
            }
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {}
                this.in = null;
            }
        }
    }

    protected void reset() {
        this.skip = false;
    }

    protected abstract void startElement(String var1, String var2);

    protected abstract void endElement(String var1);

    protected final Map<String, String> parseAttributes(String unparsedAttributes) {
        return XMLParserHelper.parseAttributes(unparsedAttributes);
    }

    protected final int getLineNumber() {
        return this.in.getLineNumber();
    }
}

