/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser;

import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.parser.NMONParser;
import com.ibm.nmon.util.DataHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HATJParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NMONParser.class);
    private static final Pattern DATA_SPLITTER = Pattern.compile(",");
    public static final String DEFAULT_HOSTNAME = "hatj";

    public BasicDataSet parse(File file) throws IOException {
        return this.parse(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicDataSet parse(String filename) throws IOException {
        long start = System.nanoTime();
        int graphIdx = filename.indexOf("graph");
        if (graphIdx == -1) {
            LOGGER.error("HATJ file name '{}' does not start with 'graph'", (Object)filename);
            return null;
        }
        int idx = filename.indexOf("_", graphIdx);
        int end = filename.length() - ".csv".length();
        String hostname = DEFAULT_HOSTNAME;
        if (idx == -1) {
            idx = end;
        } else {
            hostname = filename.substring(idx + 1, end);
        }
        String temp = filename.substring(graphIdx + "graph".length(), idx);
        long startTime = 0L;
        try {
            startTime = Long.parseLong(temp);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("no valid start time in the file name, using the current time", (Object)filename);
            startTime = System.currentTimeMillis();
        }
        BufferedReader in = null;
        try {
            in = new LineNumberReader(new FileReader(filename));
            String line = ((LineNumberReader)in).readLine();
            if (line == null) {
                throw new IOException("file '" + filename + "' does not appear to have any data records");
            }
            BasicDataSet data = new BasicDataSet(filename);
            data.setHostname(hostname);
            String[] values = DATA_SPLITTER.split(line);
            String[] fields = new String[values.length - 4];
            for (int i = 0; i < fields.length; ++i) {
                String raw = values[i + 4];
                idx = raw.indexOf(46);
                int lastDot = -1;
                StringBuilder txName = new StringBuilder(64);
                txName.append(raw.charAt(0)).append('.');
                while (idx != -1) {
                    txName.append(raw.charAt(++idx)).append('.');
                    lastDot = idx;
                    idx = raw.indexOf(46, idx);
                }
                txName.deleteCharAt(txName.length() - 1);
                idx = raw.indexOf(40, ++lastDot);
                if (idx == -1) {
                    txName.append(raw.substring(lastDot));
                } else {
                    txName.append(raw.substring(lastDot, idx));
                    for (int j = idx; j < raw.length(); ++j) {
                        if (raw.charAt(j) == ' ') continue;
                        txName.append(raw.charAt(j));
                    }
                }
                fields[i] = txName.toString();
            }
            DataType info = new DataType("INFO", "HATJ Test Information", "throughput", "hits", "users");
            DataType response = new DataType("RESP", "HATJ Response Times", fields);
            data.addType(info);
            data.addType(response);
            while ((line = ((LineNumberReader)in).readLine()) != null) {
                values = DATA_SPLITTER.split(line);
                long duration = Long.parseLong(values[0]);
                DataRecord record = new DataRecord(startTime + duration * 1000L, DataHelper.newString(values[0]));
                record.addData(info, new double[]{Double.parseDouble(values[1]), Double.parseDouble(values[2]), Double.parseDouble(values[3])});
                double[] recordData = new double[response.getFieldCount()];
                int n = 0;
                for (int i = 4; i < values.length; ++i) {
                    recordData[n] = "".equals(values[i]) || values[i].contains("nan") ? Double.NaN : Double.parseDouble(values[i]);
                    ++n;
                }
                record.addData(response, recordData);
                data.addRecord(record);
            }
            BasicDataSet basicDataSet = data;
            return basicDataSet;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                in = null;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parse complete for {} in {}ms", (Object)filename, (Object)((double)(System.nanoTime() - start) / 1000000.0));
            }
        }
    }
}

