/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.SubDataType;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSONParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONParser.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private BasicDataSet data = null;
    private SimpleDateFormat format = null;

    public BasicDataSet parse(File file) throws IOException, ParseException {
        return this.parse(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicDataSet parse(String filename) throws IOException, JsonParseException {
        long start = System.nanoTime();
        try {
            Map root = (Map)MAPPER.readValue(new File(filename), (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.data = new BasicDataSet(filename);
            Object temp = root.get("hostname");
            if (temp == null) {
                throw new IOException("field 'hostname' not found");
            }
            this.data.setHostname((String)temp);
            this.format = this.parseDateFormat(root.get("whenPattern"), root.get("timezone"));
            this.parseMetadata(root.get("metadata"));
            this.parseTypes(root.get("types"));
            this.parseData(root.get("data"));
            BasicDataSet basicDataSet = this.data;
            return basicDataSet;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parse complete for {} in {}ms", (Object)this.data.getSourceFile(), (Object)((double)(System.nanoTime() - start) / 1000000.0));
            }
            this.data = null;
            this.format = null;
        }
    }

    private SimpleDateFormat parseDateFormat(Object whenPattern, Object timezone) throws IOException {
        if (whenPattern == null) {
            throw new IOException("field 'whenPattern' not found");
        }
        this.format = new SimpleDateFormat((String)whenPattern);
        if (timezone != null) {
            if (timezone instanceof Number) {
                Number tz = (Number)timezone;
                this.format.setTimeZone(new SimpleTimeZone((int)(tz.doubleValue() * 3600000.0), tz.toString()));
            } else if (timezone instanceof String) {
                this.format.setTimeZone(SimpleTimeZone.getTimeZone((String)timezone));
                if (this.format.getTimeZone().equals(SimpleTimeZone.getTimeZone("GMT"))) {
                    LOGGER.warn("'timezone' value defined as '{}' but Java interpreted this as GMT; are you sure this is a valid value?", timezone);
                }
            } else {
                LOGGER.warn("timezone '{}' is not a valid format; it must be a number or a String", timezone);
            }
            this.data.setMetadata("timezone", this.format.getTimeZone().getDisplayName());
        } else {
            LOGGER.info("no 'timezone' value defined; defaulting to {}, ({})", (Object)this.format.getTimeZone().getID(), (Object)((double)this.format.getTimeZone().getRawOffset() / 3600000.0));
        }
        return this.format;
    }

    private void parseMetadata(Object rawMetadata) {
        if (rawMetadata != null) {
            Map metadata = (Map)rawMetadata;
            for (String name : metadata.keySet()) {
                this.data.setMetadata(name, (String)metadata.get(name));
            }
        }
    }

    private void parseTypes(Object rawTypes) throws IOException {
        if (rawTypes == null) {
            throw new IOException("'types' must be defined");
        }
        List types = (List)rawTypes;
        if (types.size() == 0) {
            throw new IOException("at least one 'type' must be defined");
        }
        for (Map type : types) {
            Object rawFields;
            String typeName = (String)type.get("name");
            String typeId = (String)type.get("id");
            if (typeId == null) {
                LOGGER.warn("typeId must be defined for each type (typeName = '{}'); it will be ignored", (Object)typeName);
                continue;
            }
            if (typeName == null) {
                typeName = typeId;
            }
            if ((rawFields = type.get("fields")) == null) {
                LOGGER.warn("no fields defined for type '{}'; it will be ignored", (Object)typeId);
                continue;
            }
            List fields = (List)rawFields;
            String[] fieldsArray = new String[fields.size()];
            for (int i = 0; i < fieldsArray.length; ++i) {
                fieldsArray[i] = (String)fields.get(i);
            }
            Object temp = type.get("subtypes");
            if (temp != null) {
                List subtypes = (List)temp;
                for (String subtype : subtypes) {
                    SubDataType dataType = new SubDataType(typeId, subtype, typeName, fieldsArray);
                    this.data.addType(dataType);
                }
                continue;
            }
            DataType dataType = new DataType(typeId, typeName, fieldsArray);
            this.data.addType(dataType);
        }
    }

    private void parseData(Object rawData) throws IOException {
        if (rawData == null) {
            throw new IOException("'data' must be defined");
        }
        List dataToParse = (List)rawData;
        if (dataToParse.size() == 0) {
            throw new IOException("at least one 'data' element must be defined");
        }
        for (Map datum : dataToParse) {
            Object temp = datum.get("when");
            if (temp == null) {
                LOGGER.warn("'when' not defined for data record; it will be ignored. Previous time was '{}'", (Object)(this.data.getRecordCount() == 0 ? "<null>" : this.format.format(new Date(this.data.getEndTime()))));
                continue;
            }
            long time = 0L;
            String timestamp = (String)temp;
            try {
                time = this.format.parse(timestamp).getTime();
            }
            catch (ParseException pe) {
                LOGGER.warn("cannot parse 'when' value '{}'; the data record will be ignored", temp);
                continue;
            }
            DataRecord record = new DataRecord(time, timestamp);
            for (DataType type : this.data.getTypes()) {
                this.parseTypeData(datum, type, record);
            }
            this.data.addRecord(record);
        }
    }

    private void parseTypeData(Map<String, Object> datum, DataType type, DataRecord record) {
        Object temp;
        String typeId = type.getId();
        boolean isSubType = false;
        if (type instanceof SubDataType) {
            typeId = ((SubDataType)type).getPrimaryId();
            isSubType = true;
        }
        if ((temp = datum.get(typeId)) == null) {
            LOGGER.warn("no data for type '{}' at time {}", (Object)typeId, (Object)this.format.format(new Date(record.getTime())));
            return;
        }
        if (isSubType) {
            if (temp instanceof Map) {
                Map map = (Map)temp;
                String subtypeId = ((SubDataType)type).getSubId();
                if ((temp = map.get(subtypeId)) == null) {
                    LOGGER.warn("no data for subtype '{}' at time {}", (Object)subtypeId, (Object)this.format.format(new Date(record.getTime())));
                    return;
                }
                List values = (List)temp;
                double[] doubleValues = new double[values.size()];
                for (int i = 0; i < doubleValues.length; ++i) {
                    Number value = (Number)values.get(i);
                    doubleValues[i] = value == null ? Double.NaN : value.doubleValue();
                }
                record.addData(type, doubleValues);
            } else {
                LOGGER.warn("unknown JSON object for type '{}' at time {}; it must be an object", (Object)type.getId(), (Object)this.format.format(new Date(record.getTime())));
            }
        } else if (temp instanceof List) {
            List values = (List)temp;
            double[] doubleValues = new double[values.size()];
            for (int i = 0; i < doubleValues.length; ++i) {
                Number value = (Number)values.get(i);
                doubleValues[i] = value == null ? Double.NaN : value.doubleValue();
            }
            record.addData(type, doubleValues);
        } else {
            LOGGER.warn("unknown JSON object for type '{}' at time {}; it must be an array", (Object)typeId, (Object)this.format.format(new Date(record.getTime())));
        }
    }
}

