/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.PerfmonDataSet;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.data.transform.WindowsBytesTransform;
import com.ibm.nmon.data.transform.WindowsNetworkPostProcessor;
import com.ibm.nmon.data.transform.WindowsProcessPostProcessor;
import com.ibm.nmon.util.DataHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfmonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfmonParser.class);
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static final Pattern DATA_SPLITTER = Pattern.compile("\"?,\\D\"?");
    private static final Pattern SUBCATEGORY_SPLITTER = Pattern.compile(":");
    private static final Matcher METRIC_MATCHER = Pattern.compile("\\\\\\\\(.*?)\\\\(.*)\\\\(.*)\"?").matcher("");
    private LineNumberReader in = null;
    private PerfmonDataSet data = null;
    private final WindowsBytesTransform bytesTransform = new WindowsBytesTransform();
    private DataTypeBuilder[] buildersByColumn;
    private Map<String, DataTypeBuilder> buildersById = new HashMap<String, DataTypeBuilder>();

    public PerfmonDataSet parse(File file, boolean scaleProcessesByCPU) throws IOException, ParseException {
        return this.parse(file.getAbsolutePath(), scaleProcessesByCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfmonDataSet parse(String filename, boolean scaleProcessesByCPU) throws IOException, ParseException {
        long start = System.nanoTime();
        this.data = new PerfmonDataSet(filename);
        this.data.setMetadata("OS", "Perfmon");
        try {
            this.in = new LineNumberReader(new FileReader(filename));
            String line = this.in.readLine();
            this.parseHeader(DATA_SPLITTER.split(line));
            while ((line = this.in.readLine()) != null) {
                this.parseData(DATA_SPLITTER.split(line));
            }
            long postProcessStart = System.nanoTime();
            WindowsNetworkPostProcessor networkPostProcessor = new WindowsNetworkPostProcessor();
            WindowsProcessPostProcessor processPostProcessor = null;
            networkPostProcessor.addDataTypes(this.data);
            if (scaleProcessesByCPU) {
                processPostProcessor = new WindowsProcessPostProcessor();
                processPostProcessor.addDataTypes(this.data);
            }
            for (DataRecord record : this.data.getRecords()) {
                networkPostProcessor.postProcess(this.data, record);
                if (!scaleProcessesByCPU) continue;
                processPostProcessor.postProcess(this.data, record);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Post processing complete for {} in {}ms", (Object)this.data.getSourceFile(), (Object)((double)(System.nanoTime() - postProcessStart) / 1000000.0));
            }
            DataHelper.aggregateProcessData(this.data, LOGGER);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parse complete for {} in {}ms", (Object)this.data.getSourceFile(), (Object)((double)(System.nanoTime() - start) / 1000000.0));
            }
            PerfmonDataSet perfmonDataSet = this.data;
            return perfmonDataSet;
        }
        finally {
            this.in.close();
            this.data = null;
            this.buildersById.clear();
            this.buildersByColumn = null;
            this.bytesTransform.reset();
        }
    }

    private void parseHeader(String[] header) {
        this.buildersByColumn = new DataTypeBuilder[header.length];
        String lastData = header[header.length - 1];
        if (lastData.endsWith("\"")) {
            header[header.length - 1] = lastData.substring(0, lastData.length() - 1);
        } else if (lastData.endsWith(",")) {
            header[header.length - 1] = lastData.substring(0, lastData.length() - 2);
        }
        int idx = header[0].lastIndexOf(40);
        if (idx == -1) {
            LOGGER.warn("version header '{0}' is not in the right format, the time zone will default to UTC", (Object)header[0]);
            TIMESTAMP_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            String temp = header[0].substring(idx + 1, header[0].length() - 1);
            try {
                double offset = (double)Integer.parseInt(temp) / -60.0;
                TIMESTAMP_FORMAT.setTimeZone(new SimpleTimeZone((int)(offset * 3600000.0), temp));
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn("version header '{0}' is not in the right format, the time zone will default to UTC", (Object)header[0]);
                TIMESTAMP_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
        }
        this.buildersByColumn[0] = null;
        METRIC_MATCHER.reset(header[1]);
        if (!METRIC_MATCHER.matches()) {
            throw new IllegalArgumentException("hostname not found in '" + header[1] + "'");
        }
        this.data.setHostname(METRIC_MATCHER.group(1).toLowerCase());
        for (int i = 1; i < header.length; ++i) {
            METRIC_MATCHER.reset(header[i]);
            if (!METRIC_MATCHER.matches()) {
                LOGGER.warn("'{}' is not a valid header column", (Object)header[i]);
                this.buildersByColumn[i] = null;
                continue;
            }
            String toParse = METRIC_MATCHER.group(2);
            String uniqueId = null;
            String id = null;
            String subId = null;
            idx = toParse.indexOf(40);
            if (idx != -1) {
                int endIdx = toParse.indexOf(41, idx + 1);
                if (endIdx == -1) {
                    LOGGER.warn("no end parentheses found in header column '{}'", (Object)toParse);
                    this.buildersByColumn[i] = null;
                    continue;
                }
                id = DataHelper.newString(toParse.substring(0, idx));
                subId = DataHelper.newString(this.parseSubId(id, toParse.substring(idx + 1, endIdx)));
                uniqueId = SubDataType.buildId(id, subId);
            } else {
                id = uniqueId = DataHelper.newString(toParse);
            }
            String field = this.parseField(id, METRIC_MATCHER.group(3));
            DataTypeBuilder builder = this.buildersById.get(uniqueId);
            if (builder == null) {
                builder = new DataTypeBuilder(uniqueId, id, subId);
                this.buildersById.put(uniqueId, builder);
            }
            if (this.data.getTypeIdPrefix().equals(id)) {
                if ("Idle".equals(subId) || "Total".equals(subId)) {
                    this.buildersByColumn[i] = null;
                    continue;
                }
                if ("ID Process".equals(field)) {
                    this.buildersByColumn[i] = null;
                    builder.setProcessIdColumn(i);
                    continue;
                }
                this.buildersByColumn[i] = builder;
                builder.addField(field);
                continue;
            }
            this.buildersByColumn[i] = builder;
            builder.addField(field);
        }
    }

    private void parseData(String[] rawData) {
        if (rawData.length != this.buildersByColumn.length) {
            LOGGER.warn("invalid number of data columns at line {}, this data will be skipped", (Object)this.in.getLineNumber());
            return;
        }
        String lastData = rawData[rawData.length - 1];
        if (lastData.endsWith("\"")) {
            rawData[rawData.length - 1] = lastData.substring(0, lastData.length() - 1);
        } else if (lastData.endsWith(",")) {
            rawData[rawData.length - 1] = lastData.substring(0, lastData.length() - 2);
        }
        String timestamp = DataHelper.newString(rawData[0].substring(1));
        long time = 0L;
        try {
            time = TIMESTAMP_FORMAT.parse(timestamp).getTime();
        }
        catch (ParseException pe) {
            LOGGER.warn("invalid timestamp format at line {}, this data will be skipped", (Object)this.in.getLineNumber());
            return;
        }
        HashMap<String, DataHolder> dataByType = new HashMap<String, DataHolder>();
        for (int i = 1; i < rawData.length; ++i) {
            DataTypeBuilder builder = this.buildersByColumn[i];
            if (builder == null) continue;
            DataHolder holder = (DataHolder)dataByType.get(builder.unique);
            if (holder == null) {
                holder = new DataHolder(builder.fields.size());
                dataByType.put(builder.unique, holder);
            }
            holder.add(this.parseDouble(rawData[i]));
        }
        DataRecord record = new DataRecord(time, timestamp);
        for (String unique : dataByType.keySet()) {
            DataTypeBuilder builder = this.buildersById.get(unique);
            DataHolder holder = (DataHolder)dataByType.get(unique);
            DataType type = builder.build(time, rawData);
            double[] values = holder.data;
            if (this.bytesTransform.isValidFor(builder.id, builder.subId)) {
                if (type.hasField("% Used Space")) {
                    int idx = type.getFieldIndex("% Used Space");
                    values[idx] = 100.0 - values[idx];
                }
                values = this.bytesTransform.transform(type, values);
            }
            record.addData(type, values);
        }
        this.data.addRecord(record);
    }

    private String parseSubId(String id, String toParse) {
        if ("Interrupt Vector".equals(id)) {
            String[] split = SUBCATEGORY_SPLITTER.split(toParse);
            return split[0];
        }
        if (id.startsWith("Group")) {
            String[] split = SUBCATEGORY_SPLITTER.split(toParse);
            return split[1];
        }
        if ("Vcpu".equals(id)) {
            String[] split = SUBCATEGORY_SPLITTER.split(toParse);
            return split[1];
        }
        if (toParse.charAt(0) == '_') {
            return toParse.substring(1);
        }
        return toParse;
    }

    private double parseDouble(String value) {
        if (value.charAt(0) == ' ') {
            return Double.NaN;
        }
        return Double.parseDouble(value);
    }

    private String parseField(String id, String toParse) {
        if ("Interrupt Vector".equals(id)) {
            String[] split = SUBCATEGORY_SPLITTER.split(toParse);
            if (split.length > 1) {
                return DataHelper.newString(split[1]);
            }
            return toParse;
        }
        return toParse;
    }

    private final class DataHolder {
        private int nextIdx = 0;
        private final double[] data;

        DataHolder(int size) {
            this.data = new double[size];
        }

        void add(double d) {
            this.data[this.nextIdx++] = d;
        }
    }

    private final class DataTypeBuilder {
        private final String unique;
        private final String id;
        private final String subId;
        private int processIdColumn = -1;
        private final List<String> fields = new ArrayList<String>();
        private DataType type;

        DataTypeBuilder(String unique, String id, String subId) {
            this.unique = unique;
            this.id = id;
            this.subId = subId;
        }

        void addField(String field) {
            this.fields.add(field);
        }

        void setProcessIdColumn(int processIdColumn) {
            this.processIdColumn = processIdColumn;
        }

        public int hashCode() {
            return this.unique.hashCode();
        }

        public boolean equals(Object o) {
            return this.unique.equals(o);
        }

        DataType build(long startTime, String[] rawData) {
            if (this.type != null) {
                return this.type;
            }
            String[] fieldsArray = new String[this.fields.size()];
            this.fields.toArray(fieldsArray);
            if (PerfmonParser.this.data.getTypeIdPrefix().equals(this.id)) {
                int pid = (int)(this.processIdColumn != -1 ? PerfmonParser.this.parseDouble(rawData[this.processIdColumn]) : 0.0);
                String processName = this.subId;
                int idx = processName.indexOf(95);
                if (idx != -1) {
                    String temp = processName.substring(idx + 1, processName.length());
                    try {
                        pid = Integer.parseInt(temp);
                        processName = DataHelper.newString(processName.substring(0, idx));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.warn("invalid pid {} at line {}; using {} instead", new Object[]{temp, PerfmonParser.this.in.getLineNumber(), pid});
                    }
                } else {
                    idx = processName.indexOf(35);
                    if (idx != -1) {
                        processName = DataHelper.newString(processName.substring(0, idx));
                    }
                }
                if (pid == 0) {
                    pid = PerfmonParser.this.data.getProcessCount() + 1;
                }
                Process process = new Process(pid, startTime, processName, PerfmonParser.this.data.getTypeIdPrefix());
                PerfmonParser.this.data.addProcess(process);
                this.type = new ProcessDataType(process, fieldsArray);
            } else {
                String name = SubDataType.buildId(this.id, this.subId);
                if (PerfmonParser.this.bytesTransform.isValidFor(this.id, this.subId)) {
                    if ("LogicalDisk".equals(this.id) || "PhysicalDisk".equals(this.id)) {
                        for (int i = 0; i < fieldsArray.length; ++i) {
                            String field = fieldsArray[i];
                            if (!"% Free Space".equals(field)) continue;
                            fieldsArray[i] = "% Used Space";
                        }
                    }
                    this.type = PerfmonParser.this.bytesTransform.buildDataType(this.id, this.subId, name, fieldsArray);
                } else {
                    this.type = this.subId == null ? new DataType(this.id, name, fieldsArray) : new SubDataType(this.id, this.subId, name, fieldsArray);
                }
            }
            PerfmonParser.this.data.addType(this.type);
            return this.type;
        }
    }
}

