/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser.gc;

import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.parser.util.XMLParserHelper;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;

public final class GCParserContext {
    private final Logger logger;
    private final BasicDataSet data;
    private DataRecord currentRecord;
    private final TimeZone timeZone;
    private int lineNumber;
    private Map<String, String> attributes;
    private boolean isGencon;
    private int compactionCount;

    GCParserContext(BasicDataSet data, Logger logger, TimeZone timeZone) {
        this.data = data;
        this.logger = logger;
        this.timeZone = timeZone;
        this.reset();
    }

    public void reset() {
        this.currentRecord = null;
        this.attributes = null;
        this.lineNumber = 0;
        this.isGencon = false;
        this.compactionCount = 0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public BasicDataSet getData() {
        return this.data;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public DataRecord getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(DataRecord currentRecord) {
        this.currentRecord = currentRecord;
    }

    public void saveRecord() {
        this.data.addRecord(this.currentRecord);
    }

    public void setGencon(boolean isGencon) {
        this.isGencon = isGencon;
    }

    public boolean isGencon() {
        return this.isGencon;
    }

    public int incrementCompactionCount() {
        return ++this.compactionCount;
    }

    public void resetCompactionCount() {
        this.compactionCount = 0;
    }

    public void setValue(String typeId, String field, String attribute) {
        String value = this.attributes.get(attribute);
        if (value == null) {
            this.logMissingAttribute(attribute);
            return;
        }
        this.currentRecord.setValue(this.getDataType(typeId), field, this.parseDouble(attribute));
    }

    public void setValue(String typeId, String field, double value) {
        this.currentRecord.setValue(this.getDataType(typeId), field, value);
    }

    public void setValueDiv1000(String typeId, String field, String name) {
        String value = this.attributes.get(name);
        if (value == null) {
            this.logMissingAttribute(name);
            return;
        }
        this.currentRecord.setValue(this.getDataType(typeId), field, this.parseDouble(name) / 1000.0);
    }

    public void parseAttributes(String unparsedAttributes) {
        this.attributes = XMLParserHelper.parseAttributes(unparsedAttributes);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public double parseDouble(String name) {
        double toReturn;
        String value = this.attributes.get(name);
        if (value == null) {
            this.logMissingAttribute(name);
            return Double.NaN;
        }
        try {
            toReturn = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            this.logger.warn("attribute '{}' with value '{}', defined at line {}, is not a number", new Object[]{name, value, this.getLineNumber()});
            toReturn = Double.NaN;
        }
        return toReturn;
    }

    public void logMissingAttribute(String attribute) {
        this.logger.warn("no attribute named {} defined at line {}", (Object)attribute, (Object)this.getLineNumber());
    }

    public void logUnrecognizedElement(String elementName) {
        this.logger.warn("unrecogized element '{}' at line {}", (Object)elementName, (Object)this.getLineNumber());
    }

    public void logInvalidValue(String attribute, String value) {
        this.logger.warn("attribute '{}' with value '{}', defined at line {}, is not a valid value", new Object[]{attribute, value, this.getLineNumber()});
    }

    public DataType getDataType(String typeId) {
        String jvmName = this.data.getMetadata("jvm_name");
        SubDataType type = (SubDataType)this.data.getType(SubDataType.buildId(typeId, jvmName));
        if (type != null) {
            return type;
        }
        if ("GCMEM".equals(typeId)) {
            type = new SubDataType("GCMEM", jvmName, "GC Memory Stats", new String[]{"requested", "total_freed", "nursery_freed", "tenured_freed", "flipped", "flipped_bytes", "tenured", "tenured_bytes", "moved", "moved_bytes"});
        } else if ("GCSTAT".equals(typeId)) {
            type = new SubDataType("GCSTAT", jvmName, "GC Memory References", new String[]{"finalizers", "soft", "weak", "phantom", "tiltratio"});
        } else if ("GCTIME".equals(typeId)) {
            type = new SubDataType("GCTIME", jvmName, "GC Times (ms)", new String[]{"total_ms", "nursery_ms", "tenured_ms", "mark_ms", "sweep_ms", "compact_ms", "exclusive_ms"});
        } else if ("GCSINCE".equals(typeId)) {
            type = new SubDataType("GCSINCE", jvmName, "Time Since Last", new String[]{"af_nursery", "af_tenured", "gc_scavenger", "gc_global", "gc_system", "con_mark"});
        } else if ("GCBEF".equals(typeId)) {
            type = new SubDataType("GCBEF", jvmName, "Sizes Before GC", new String[]{"total", "free", "used", "total_nursery", "free_nursery", "used_nursery", "total_tenured", "free_tenured", "used_tenured"});
        } else if ("GCAFT".equals(typeId)) {
            type = new SubDataType("GCAFT", jvmName, "Sizes After GC", new String[]{"total", "free", "used", "total_nursery", "free_nursery", "used_nursery", "total_tenured", "free_tenured", "used_tenured"});
        } else if ("GCCOUNT".equals(typeId)) {
            type = new SubDataType("GCCOUNT", jvmName, "GC Counts", new String[]{"total_count", "nursery_count", "tenured_count", "compaction_count", "system_count"});
        } else {
            throw new IllegalArgumentException("invalid type " + typeId);
        }
        this.data.addType(type);
        return type;
    }
}

