/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser.gc;

import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.parser.BasicXMLParser;
import com.ibm.nmon.parser.gc.GCParserContext;
import com.ibm.nmon.parser.gc.state.GCState;
import com.ibm.nmon.parser.gc.state.Start;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;

public class VerboseGCParser
extends BasicXMLParser {
    private GCParserContext context;
    private GCState currentState;

    public VerboseGCParser() {
        this.reset();
    }

    public DataSet parse(File file, TimeZone timeZone, String hostname, String jvmName) throws IOException {
        return this.parse(file.getAbsolutePath(), timeZone, hostname, jvmName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet parse(String filename, TimeZone timeZone, String hostname, String jvmName) throws IOException {
        long start = System.nanoTime();
        BasicDataSet data = new BasicDataSet(filename);
        data.setHostname(hostname);
        data.setMetadata("jvm_name", jvmName);
        this.context = new GCParserContext(data, this.logger, timeZone);
        try {
            this.parse(filename);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parse complete for file '{}' in {}ms", (Object)data.getSourceFile(), (Object)((double)(System.nanoTime() - start) / 1000000.0));
            }
            if (data.getRecordCount() == 0) {
                throw new IOException("verbose GC log file '" + filename + "' does not appear to have any data records");
            }
            BasicDataSet basicDataSet = data;
            return basicDataSet;
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.context = null;
        this.currentState = Start.INSTANCE;
        this.currentState.reset();
    }

    @Override
    public void startElement(String element, String unparsedAttributes) {
        this.context.setLineNumber(this.getLineNumber());
        this.currentState = this.currentState.startElement(this.context, element, unparsedAttributes);
    }

    @Override
    public void endElement(String element) {
        this.context.setLineNumber(this.getLineNumber());
        this.currentState = this.currentState.endElement(this.context, element);
    }
}

