/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser.gc.state;

import com.ibm.nmon.parser.gc.GCParserContext;
import com.ibm.nmon.parser.gc.state.GCState;
import com.ibm.nmon.parser.gc.state.GCStateWithParent;
import com.ibm.nmon.parser.gc.state.Java6GCCycle;
import com.ibm.nmon.parser.gc.state.JavaGCCycle;

final class Java6Collection
extends GCStateWithParent {
    private String type;
    private boolean tenuredCountComplete;

    @Override
    public GCState startElement(GCParserContext context, String elementName, String unparsedAttributes) {
        context.parseAttributes(unparsedAttributes);
        if ("gc".equals(elementName)) {
            this.type = context.getAttribute("type");
            this.tenuredCountComplete = false;
            if ("scavenger".equals(this.type)) {
                context.setValueDiv1000("GCSINCE", "gc_scavenger", "intervalms");
                context.setValue("GCCOUNT", "nursery_count", "id");
                context.setValue("GCCOUNT", "total_count", "totalid");
            } else if ("global".equals(this.type)) {
                context.setValueDiv1000("GCSINCE", "gc_global", "intervalms");
                context.setValue("GCCOUNT", "tenured_count", "id");
                context.setValue("GCCOUNT", "total_count", "totalid");
                this.tenuredCountComplete = true;
            } else {
                context.logInvalidValue("type", this.type);
                ((JavaGCCycle)this.parent).error = true;
            }
        } else if ("flipped".equals(elementName)) {
            context.setValue("GCMEM", "flipped", "objectcount");
            context.setValue("GCMEM", "flipped_bytes", "bytes");
        } else if ("tenured".equals(elementName)) {
            if (!this.tenuredCountComplete) {
                context.setValue("GCMEM", "tenured", "objectcount");
                context.setValue("GCMEM", "tenured_bytes", "bytes");
                this.tenuredCountComplete = true;
            } else {
                this.tenuredCountComplete = false;
            }
        } else if ("finalization".equals(elementName)) {
            context.setValue("GCSTAT", "finalizers", "objectsqueued");
        } else if ("compaction".equals(elementName)) {
            context.setValue("GCMEM", "moved", "movecount");
            context.setValue("GCMEM", "moved_bytes", "movebytes");
            context.setValue("GCCOUNT", "compaction_count", context.incrementCompactionCount());
        } else if ("scavenger".equals(elementName)) {
            context.setValue("GCSTAT", "tiltratio", "tiltratio");
        } else if ("time".equals(elementName)) {
            if ("scavenger".equals(this.type)) {
                context.setValue("GCTIME", "nursery_ms", "totalms");
            }
        } else if ("timesms".equals(elementName)) {
            context.setValue("GCTIME", "tenured_ms", "total");
            context.setValue("GCTIME", "mark_ms", "mark");
            context.setValue("GCTIME", "sweep_ms", "sweep");
            context.setValue("GCTIME", "compact_ms", "compact");
        }
        return this;
    }

    Java6Collection(Java6GCCycle parent) {
        super("gc", parent);
    }
}

