/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser.gc.state;

import com.ibm.nmon.parser.gc.GCParserContext;
import com.ibm.nmon.parser.gc.state.ConcurrentGCCycle;
import com.ibm.nmon.parser.gc.state.GCState;
import com.ibm.nmon.parser.gc.state.Initialized;
import com.ibm.nmon.parser.gc.state.Java6GCCycle;
import com.ibm.nmon.parser.gc.state.Start;
import java.util.TimeZone;

final class Java6GC
implements GCState {
    static final Java6GC INSTANCE = new Java6GC();
    private final Initialized initialized = new Initialized(this);
    private final Java6GCCycle nurseryAF = new Java6GCCycle("af", "af_nursery"){};
    private final Java6GCCycle tenuredAF = new Java6GCCycle("af", "af_tenured"){};
    private final Java6GCCycle systemGC = new Java6GCCycle("sys", "gc_system"){

        @Override
        protected GCState onStartCycle(GCParserContext context, String elementName, String unparsedAttributes) {
            GCState toReturn = super.onStartCycle(context, elementName, unparsedAttributes);
            context.setValue("GCCOUNT", "system_count", "id");
            return toReturn;
        }
    };
    private final Java6GCCycle concurrentGC = new ConcurrentGCCycle();

    @Override
    public GCState startElement(GCParserContext context, String elementName, String unparsedAttributes) {
        if ("initialized".equals(elementName)) {
            return this.initialized;
        }
        context.parseAttributes(unparsedAttributes);
        if ("sys".equals(elementName)) {
            return this.systemGC.startElement(context, elementName, unparsedAttributes);
        }
        if ("af".equals(elementName)) {
            String afType = context.getAttribute("type");
            if ("nursery".equals(afType)) {
                return this.nurseryAF.startElement(context, elementName, unparsedAttributes);
            }
            if ("tenured".equals(afType)) {
                return this.tenuredAF.startElement(context, elementName, unparsedAttributes);
            }
            context.logInvalidValue("type", afType);
            return this;
        }
        if ("con".equals(elementName)) {
            return this.concurrentGC.startElement(context, elementName, unparsedAttributes);
        }
        context.logUnrecognizedElement(elementName);
        return this;
    }

    @Override
    public GCState endElement(GCParserContext context, String elementName) {
        if ("verbosegc".equals(elementName)) {
            context.reset();
            this.reset();
            return Start.INSTANCE;
        }
        return this;
    }

    void setTimeZone(TimeZone timeZone) {
        this.nurseryAF.setTimeZone(timeZone);
        this.tenuredAF.setTimeZone(timeZone);
        this.systemGC.setTimeZone(timeZone);
        this.concurrentGC.setTimeZone(timeZone);
    }

    @Override
    public void reset() {
        this.nurseryAF.reset();
        this.tenuredAF.reset();
        this.systemGC.reset();
        this.concurrentGC.reset();
    }

    private Java6GC() {
    }
}

