/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser.gc.state;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.parser.gc.GCParserContext;
import com.ibm.nmon.parser.gc.state.GCState;
import com.ibm.nmon.parser.gc.state.Java6Collection;
import com.ibm.nmon.parser.gc.state.Java6GC;
import com.ibm.nmon.parser.gc.state.JavaGCCycle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

abstract class Java6GCCycle
extends JavaGCCycle {
    private final SimpleDateFormat datetime = new SimpleDateFormat("MMM dd HH:mm:ss yyyy", Locale.US);
    protected final String transitionElement;
    private final String intervalField;
    private long baseTime;
    private double accumulatedTime;
    private final Java6Collection collection;

    Java6GCCycle(String transitionElement, String intervalField) {
        this.transitionElement = transitionElement;
        this.intervalField = intervalField;
        this.collection = new Java6Collection(this);
    }

    @Override
    public final GCState startElement(GCParserContext context, String elementName, String unparsedAttributes) {
        if (this.transitionElement.equals(elementName)) {
            return this.onStartCycle(context, elementName, unparsedAttributes);
        }
        if ("gc".equals(elementName)) {
            this.beforeGC = false;
            return this.collection.startElement(context, elementName, unparsedAttributes);
        }
        if ("time".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            if (this.beforeGC) {
                double exclusive = context.parseDouble("exclusiveaccessms");
                if (exclusive > 8.64E7) {
                    context.logInvalidValue("exlusiveaccessms", context.getAttribute("exclusiveaccessms"));
                    this.error = true;
                } else {
                    context.setValue("GCTIME", "exclusive_ms", exclusive);
                }
            } else {
                context.setValue("GCTIME", "total_ms", "totalms");
            }
        } else if ("nursery".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            this.calculateSizes(context, elementName, "freebytes", "totalbytes");
        } else if ("tenured".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            this.calculateSizes(context, elementName, "freebytes", "totalbytes");
        } else if ("refs_cleared".equals(elementName) || "refs".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            context.setValue("GCSTAT", "soft", "soft");
            context.setValue("GCSTAT", "weak", "weak");
            context.setValue("GCSTAT", "phantom", "phantom");
        } else if ("minimum".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            context.setValue("GCMEM", "requested", "requested_bytes");
        }
        return this;
    }

    @Override
    public GCState endElement(GCParserContext context, String elementName) {
        if (elementName.equals(this.transitionElement)) {
            if (!this.error) {
                this.calculateTotalSizes(context);
                context.saveRecord();
            }
            this.error = false;
            this.beforeGC = true;
            return Java6GC.INSTANCE;
        }
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.baseTime = 0L;
        this.accumulatedTime = 0.0;
    }

    protected GCState onStartCycle(GCParserContext context, String elementName, String unparsedAttributes) {
        this.calculateTime(context);
        return this;
    }

    protected final void calculateTime(GCParserContext context) {
        double intervalms;
        boolean first = false;
        if (this.baseTime == 0L) {
            this.baseTime = this.parseTimestamp(context);
            if (this.baseTime == 0L) {
                this.error = true;
                return;
            }
            first = true;
        }
        if (Double.isNaN(intervalms = context.parseDouble("intervalms"))) {
            this.error = true;
            return;
        }
        if (intervalms > 8.64E7) {
            context.logInvalidValue("intervalms", context.getAttribute("intervalms"));
            this.error = true;
            return;
        }
        this.accumulatedTime += intervalms;
        context.setCurrentRecord(new DataRecord((long)((double)this.baseTime + this.accumulatedTime), String.format("%08x", context.getData().getRecordCount()).toString()));
        if (!first) {
            context.setValue("GCSINCE", this.intervalField, intervalms / 1000.0);
        }
    }

    void setTimeZone(TimeZone timeZone) {
        this.datetime.setTimeZone(timeZone);
    }

    private long parseTimestamp(GCParserContext context) {
        long toReturn;
        String value = context.getAttribute("timestamp");
        if (value == null) {
            context.logMissingAttribute("timestamp");
            return 0L;
        }
        try {
            toReturn = this.datetime.parse(value).getTime();
        }
        catch (ParseException pe) {
            context.logInvalidValue("timestamp", value);
            toReturn = 0L;
        }
        return toReturn;
    }
}

