/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.parser.gc.state;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.parser.gc.GCParserContext;
import com.ibm.nmon.parser.gc.state.GCState;
import com.ibm.nmon.parser.gc.state.Initialized;
import com.ibm.nmon.parser.gc.state.Java7GCCycle;
import com.ibm.nmon.parser.gc.state.Start;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

final class Java7GC
implements GCState {
    static final Java7GC INSTANCE = new Java7GC();
    private final SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
    private final Initialized initialized = new Initialized(this);
    private double timeSince;
    private double afInterval;
    private int totalCount;
    private int nurseryCount;
    private int tenuredCount;
    private int systemCount;

    @Override
    public GCState startElement(GCParserContext context, String elementName, String unparsedAttributes) {
        if ("initialized".equals(elementName)) {
            return this.initialized;
        }
        if ("exclusive-start".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            this.timeSince = context.parseDouble("intervalms") / 1000.0;
            context.setCurrentRecord(new DataRecord(this.parseTimestamp(context), String.format("%08x", context.getData().getRecordCount()).toString()));
        } else if ("sys-start".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            context.setValue("GCSINCE", "gc_system", this.timeSince);
            context.setValue("GCCOUNT", "system_count", ++this.systemCount);
        } else if ("af-start".equals(elementName)) {
            context.parseAttributes(unparsedAttributes);
            this.afInterval = context.parseDouble("intervalms") / 1000.0;
            context.setValue("GCMEM", "requested", "totalBytesRequested");
        } else {
            if ("cycle-start".equals(elementName)) {
                context.parseAttributes(unparsedAttributes);
                String type = context.getAttribute("type");
                if (type.startsWith("global")) {
                    context.setValueDiv1000("GCSINCE", "gc_global", "intervalms");
                    if (this.afInterval >= 0.0) {
                        context.setValue("GCSINCE", "af_tenured", this.afInterval);
                    }
                    context.setValue("GCCOUNT", "tenured_count", ++this.tenuredCount);
                } else if ("scavenge".equals(type)) {
                    context.setValueDiv1000("GCSINCE", "gc_scavenger", "intervalms");
                    if (this.afInterval >= 0.0) {
                        context.setValue("GCSINCE", "af_nursery", this.afInterval);
                    }
                    context.setValue("GCCOUNT", "nursery_count", ++this.nurseryCount);
                }
                context.setValue("GCCOUNT", "total_count", ++this.totalCount);
                return Java7GCCycle.INSTANCE;
            }
            if ("response-info".equals(elementName)) {
                context.parseAttributes(unparsedAttributes);
                context.setValue("GCTIME", "exclusive_ms", "timems");
            } else if ("exclusive-end".equals(elementName)) {
                context.parseAttributes(unparsedAttributes);
                context.setValue("GCTIME", "total_ms", "durationms");
            }
        }
        return this;
    }

    @Override
    public GCState endElement(GCParserContext context, String elementName) {
        if ("verbosegc".equals(elementName)) {
            context.reset();
            this.reset();
            return Start.INSTANCE;
        }
        if ("exclusive-end".equals(elementName)) {
            context.saveRecord();
            this.timeSince = 0.0;
            this.afInterval = -1.0;
            Java7GCCycle.INSTANCE.reset();
            return this;
        }
        return this;
    }

    @Override
    public void reset() {
        this.timeSince = 0.0;
        this.afInterval = -1.0;
        this.totalCount = 0;
        this.nurseryCount = 0;
        this.tenuredCount = 0;
        this.systemCount = 0;
        Java7GCCycle.INSTANCE.reset();
    }

    void setTimeZone(TimeZone timeZone) {
        this.datetime.setTimeZone(timeZone);
    }

    private long parseTimestamp(GCParserContext context) {
        long toReturn;
        String value = context.getAttribute("timestamp");
        if (value == null) {
            context.logMissingAttribute("timestamp");
            return 0L;
        }
        try {
            toReturn = this.datetime.parse(value).getTime();
        }
        catch (ParseException pe) {
            context.logInvalidValue("timestamp", value);
            toReturn = 0L;
        }
        return toReturn;
    }

    private Java7GC() {
        this.reset();
    }
}

