/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.report;

import com.ibm.nmon.chart.definition.BarChartDefinition;
import com.ibm.nmon.chart.definition.BaseChartDefinition;
import com.ibm.nmon.chart.definition.ChartDefinitionParser;
import com.ibm.nmon.chart.definition.HistogramChartDefinition;
import com.ibm.nmon.chart.definition.IntervalChartDefinition;
import com.ibm.nmon.chart.definition.LineChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.data.definition.DefaultDataDefinition;
import com.ibm.nmon.data.definition.ExactDataDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import com.ibm.nmon.data.matcher.ExactFieldMatcher;
import com.ibm.nmon.data.matcher.ExactTypeMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportCache.class);
    public static final String DEFAULT_SUMMARY_CHARTS_KEY = "summary";
    public static final String DEFAULT_INTERVAL_CHARTS_KEY = "interval";
    public static final String DEFAULT_DATASET_CHARTS_KEY = "dataset";
    private final ChartDefinitionParser parser = new ChartDefinitionParser();
    private Map<String, List<BaseChartDefinition>> reports = new HashMap<String, List<BaseChartDefinition>>();

    public ReportCache() {
        try {
            this.reports.put(DEFAULT_SUMMARY_CHARTS_KEY, this.parser.parseCharts(this.getClass().getResourceAsStream("/com/ibm/nmon/report/summary_single_interval.xml")));
            this.reports.put(DEFAULT_INTERVAL_CHARTS_KEY, this.parser.parseCharts(this.getClass().getResourceAsStream("/com/ibm/nmon/report/summary_all_intervals.xml")));
            this.reports.put(DEFAULT_DATASET_CHARTS_KEY, this.parser.parseCharts(this.getClass().getResourceAsStream("/com/ibm/nmon/report/dataset_report.xml")));
        }
        catch (IOException e) {
            LOGGER.error("cannot parse default report definition xmls", (Throwable)e);
        }
    }

    public void addReport(String key, String file) throws IOException {
        if (DEFAULT_SUMMARY_CHARTS_KEY.equals(key) || DEFAULT_INTERVAL_CHARTS_KEY.equals(key) || DEFAULT_DATASET_CHARTS_KEY.equals(key)) {
            throw new IllegalArgumentException("cannot redefine default charts for key " + key);
        }
        this.reports.put(key, this.parser.parseCharts(file));
        LOGGER.debug("caching chart definitions from '{}' to key '{}'", (Object)file, (Object)key);
    }

    public List<BaseChartDefinition> getReport(String key) {
        List<BaseChartDefinition> toReturn = this.reports.get(key);
        if (toReturn == null) {
            toReturn = Collections.emptyList();
        }
        return toReturn;
    }

    public List<BaseChartDefinition> getReport(String key, Iterable<? extends DataSet> dataSets) {
        List<BaseChartDefinition> report = this.reports.get(key);
        if (report == null) {
            return Collections.emptyList();
        }
        ArrayList<BaseChartDefinition> toReturn = new ArrayList<BaseChartDefinition>(report.size());
        block0: for (BaseChartDefinition chartDefinition : report) {
            for (DataSet dataSet : dataSets) {
                for (DataDefinition definition : chartDefinition.getData()) {
                    if (!definition.matchesHost(dataSet) || definition.getMatchingTypes(dataSet).size() <= 0) continue;
                    toReturn.add(chartDefinition);
                    continue block0;
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("reduced {} charts to {} for data {}: {}", new Object[]{report.size(), toReturn.size(), dataSets, toReturn});
        }
        return toReturn;
    }

    public List<BaseChartDefinition> multiplexChartsAcrossTypes(String key, DataSet data, boolean filterByData) {
        List<BaseChartDefinition> chartDefinitions = null;
        chartDefinitions = filterByData ? this.getReport(key, Collections.singletonList(data)) : this.getReport(key);
        LOGGER.debug("multiplexing charts {} for dataset {} across types", chartDefinitions, (Object)data.getHostname());
        ArrayList<BaseChartDefinition> multiplexedChartDefinitions = new ArrayList<BaseChartDefinition>(10 * chartDefinitions.size());
        for (BaseChartDefinition chartDefinition : chartDefinitions) {
            for (DataDefinition dataDefinition : chartDefinition.getData()) {
                if (!dataDefinition.matchesHost(data)) continue;
                for (DataType type : dataDefinition.getMatchingTypes(data)) {
                    BaseChartDefinition newChartDefinition = this.copyChart(chartDefinition);
                    newChartDefinition.setShortName(chartDefinition.getShortName() + "_" + dataDefinition.renameType(type));
                    newChartDefinition.setTitle(chartDefinition.getTitle());
                    newChartDefinition.setSubtitleNamingMode(NamingMode.TYPE);
                    DataDefinition newData = null;
                    if (dataDefinition instanceof DefaultDataDefinition) {
                        DefaultDataDefinition old = (DefaultDataDefinition)dataDefinition;
                        newData = old.withNewTypes(new ExactTypeMatcher(type.toString()));
                    } else {
                        newData = new ExactDataDefinition(data, type, dataDefinition.getMatchingFields(type), dataDefinition.getStatistic(), dataDefinition.usesSecondaryYAxis());
                    }
                    newChartDefinition.addData(newData);
                    multiplexedChartDefinitions.add(newChartDefinition);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("multiplexed charts {} for dataset {} across types to {}", new Object[]{chartDefinitions, data.getHostname(), multiplexedChartDefinitions});
        }
        return multiplexedChartDefinitions;
    }

    public List<BaseChartDefinition> multiplexChartsAcrossFields(String key, DataSet data, boolean filterByData) {
        List<BaseChartDefinition> chartDefinitions = null;
        chartDefinitions = filterByData ? this.getReport(key, Collections.singletonList(data)) : this.getReport(key);
        LOGGER.debug("multiplexing charts {} for dataset {} across fields", chartDefinitions, (Object)data.getHostname());
        ArrayList<BaseChartDefinition> multiplexedChartDefinitions = new ArrayList<BaseChartDefinition>(10 * chartDefinitions.size());
        for (BaseChartDefinition chartDefinition : chartDefinitions) {
            for (DataDefinition dataDefinition : chartDefinition.getData()) {
                if (!dataDefinition.matchesHost(data)) continue;
                for (DataType type : dataDefinition.getMatchingTypes(data)) {
                    for (String field : dataDefinition.getMatchingFields(type)) {
                        BaseChartDefinition newChartDefinition = this.copyChart(chartDefinition);
                        newChartDefinition.setShortName(chartDefinition.getShortName() + "_" + dataDefinition.renameField(field));
                        newChartDefinition.setTitle(chartDefinition.getTitle());
                        newChartDefinition.setSubtitleNamingMode(NamingMode.FIELD);
                        DataDefinition newData = null;
                        if (dataDefinition instanceof DefaultDataDefinition) {
                            DefaultDataDefinition old = (DefaultDataDefinition)dataDefinition;
                            newData = old.withNewFields(new ExactFieldMatcher(field));
                        } else {
                            newData = new ExactDataDefinition(data, type, Collections.singletonList(field), dataDefinition.getStatistic(), dataDefinition.usesSecondaryYAxis());
                        }
                        newChartDefinition.addData(newData);
                        multiplexedChartDefinitions.add(newChartDefinition);
                    }
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("multiplexed charts {} for dataset {} across fields to {}", new Object[]{chartDefinitions, data.getHostname(), multiplexedChartDefinitions});
        }
        return multiplexedChartDefinitions;
    }

    private BaseChartDefinition copyChart(BaseChartDefinition copy) {
        if (copy.getClass().equals(LineChartDefinition.class)) {
            return new LineChartDefinition((LineChartDefinition)copy, false);
        }
        if (copy.getClass().equals(BarChartDefinition.class)) {
            return new BarChartDefinition((BarChartDefinition)copy, false);
        }
        if (copy.getClass().equals(IntervalChartDefinition.class)) {
            return new IntervalChartDefinition((IntervalChartDefinition)copy, false);
        }
        if (copy.getClass().equals(HistogramChartDefinition.class)) {
            return new HistogramChartDefinition((HistogramChartDefinition)copy, false);
        }
        return null;
    }
}

