/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class BasicFormatter
extends Formatter {
    private final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        StringWriter buffer = new StringWriter(256);
        buffer.append(this.format.format(record.getMillis()));
        buffer.append(" ");
        buffer.append(record.getLevel().getName());
        buffer.append(" ");
        buffer.append(record.getSourceClassName());
        buffer.append(".");
        buffer.append(record.getSourceMethodName());
        buffer.append(": ");
        buffer.append(record.getMessage());
        buffer.append("\n");
        if (record.getThrown() != null) {
            PrintWriter pw = new PrintWriter(buffer);
            record.getThrown().printStackTrace(pw);
            pw.close();
        }
        return buffer.toString();
    }
}

