/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.gui.chart.data.DataTupleCategoryDataset;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.gui.chart.data.DataTupleXYDataset;
import com.ibm.nmon.interval.Interval;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class CSVWriter {
    private static final SimpleDateFormat DATETIME = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
    private static final DecimalFormat FORMAT = new DecimalFormat("0.000");

    public static final void write(DataSet data, Interval interval, Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder(1024);
        builder.append("Date,Time,");
        for (DataType type : data.getTypes()) {
            for (String field : type.getFields()) {
                CSVWriter.escape(type.toString(), builder);
                builder.append(' ');
                CSVWriter.escape(field, builder);
                builder.append(',');
            }
        }
        builder.setCharAt(builder.length() - 1, '\n');
        writer.write(builder.toString());
        builder.setLength(0);
        for (DataRecord record : data.getRecords(interval)) {
            builder.append(DATETIME.format(new Date(record.getTime())));
            builder.append(',');
            for (DataType type : data.getTypes()) {
                if (record.hasData(type)) {
                    for (String field : type.getFields()) {
                        builder.append(FORMAT.format(record.getData(type, field)));
                        builder.append(',');
                    }
                    continue;
                }
                for (int i = 0; i < type.getFieldCount(); ++i) {
                    builder.append(',');
                }
            }
            builder.setCharAt(builder.length() - 1, '\n');
            writer.write(builder.toString());
            builder.setLength(0);
        }
    }

    public static final void write(DataSet data, DataType type, Interval interval, Writer writer) throws IOException {
        CSVWriter.write(data, type, type.getFields(), interval, writer);
    }

    public static final void write(DataSet data, DataType type, String field, Interval interval, Writer writer) throws IOException {
        CSVWriter.write(data, type, Collections.singletonList(field), interval, writer);
    }

    public static final void write(DataSet data, DataType type, List<String> fields, Interval interval, Writer writer) throws IOException {
        writer.write("Date,Time,");
        for (int i = 0; i < fields.size() - 1; ++i) {
            CSVWriter.escape(fields.get(i), writer);
            writer.write(44);
        }
        CSVWriter.escape(fields.get(fields.size() - 1), writer);
        writer.write(10);
        for (DataRecord record : data.getRecords(interval)) {
            int i;
            writer.write(DATETIME.format(new Date(record.getTime())));
            writer.write(44);
            if (record.hasData(type)) {
                for (i = 0; i < fields.size() - 1; ++i) {
                    writer.write(FORMAT.format(record.getData(type, fields.get(i))));
                    writer.write(44);
                }
                writer.write(FORMAT.format(record.getData(type, fields.get(fields.size() - 1))));
            } else {
                for (i = 0; i < fields.size(); ++i) {
                    writer.write(44);
                }
            }
            writer.write(10);
        }
    }

    public static void writeProcesses(DataSet data, Writer writer) throws IOException {
        if (data instanceof ProcessDataSet) {
            ProcessDataSet processData = (ProcessDataSet)data;
            writer.write("PID,Name,StartDate,StartTime,EndDate,EndTime,CommandLine\n");
            for (Process process : processData.getProcesses()) {
                writer.write(Integer.toString(process.getId()));
                writer.write(44);
                CSVWriter.escape(process.getName(), writer);
                writer.write(44);
                writer.write(DATETIME.format(process.getStartTime()));
                writer.write(44);
                writer.write(DATETIME.format(process.getEndTime()));
                writer.write(44);
                writer.write(34);
                CSVWriter.escape(process.getCommandLine(), writer);
                writer.write(34);
                writer.write(10);
            }
        }
    }

    public static void write(DataTupleDataset data, Writer writer) throws IOException {
        if (data instanceof DataTupleXYDataset) {
            CSVWriter.write((DataTupleXYDataset)data, writer);
        } else if (data instanceof DataTupleCategoryDataset) {
            CSVWriter.write((DataTupleCategoryDataset)data, writer);
        }
    }

    public static void write(DataTupleXYDataset data, Writer writer) throws IOException {
        int i;
        writer.write("Date,Time,");
        int seriesCount = data.getSeriesCount();
        for (i = 0; i < seriesCount - 1; ++i) {
            writer.write(data.getSeriesKey(i).toString());
            writer.write(44);
        }
        writer.write(data.getSeriesKey(seriesCount - 1).toString());
        writer.write(10);
        for (i = 0; i < data.getItemCount(); ++i) {
            writer.write(DATETIME.format(data.getTimePeriod(i).getEnd()));
            writer.write(44);
            for (int j = 0; j < seriesCount - 1; ++j) {
                Number n = data.getY(j, i);
                if (n == null) {
                    writer.write(FORMAT.format(Double.NaN));
                } else {
                    writer.write(FORMAT.format(n.doubleValue()));
                }
                writer.write(44);
            }
            Number n = data.getY(seriesCount - 1, i);
            if (n == null) {
                writer.write(FORMAT.format(Double.NaN));
            } else {
                writer.write(FORMAT.format(n.doubleValue()));
            }
            writer.write(10);
        }
    }

    public static void write(DataTupleCategoryDataset data, Writer writer) throws IOException {
        int i;
        writer.write(44);
        int columnCount = data.getColumnCount();
        for (i = 0; i < columnCount - 1; ++i) {
            writer.write(data.getColumnKey(i).toString());
            writer.write(44);
        }
        writer.write(data.getColumnKey(columnCount - 1).toString());
        writer.write(10);
        for (i = 0; i < data.getRowCount(); ++i) {
            Comparable rowKey = data.getRowKey(i);
            writer.write(rowKey.toString());
            writer.write(44);
            for (int j = 0; j < columnCount - 1; ++j) {
                Number o = data.getValue(rowKey, data.getColumnKey(j));
                if (o == null) {
                    writer.write(FORMAT.format(Double.NaN));
                } else {
                    writer.write(FORMAT.format((Double)o));
                }
                writer.write(44);
            }
            Number o = data.getValue(rowKey, data.getColumnKey(columnCount - 1));
            if (o == null) {
                writer.write(FORMAT.format(Double.NaN));
            } else {
                writer.write(FORMAT.format((Double)o));
            }
            writer.write(10);
        }
    }

    private static void escape(String toEscape, Appendable appendable) throws IOException {
        if (toEscape.indexOf("\"") == -1 && toEscape.indexOf(",") == -1) {
            appendable.append(toEscape);
        } else {
            toEscape = toEscape.replaceAll("\"", "\"\"");
            appendable.append("\"");
            appendable.append(toEscape);
            appendable.append("\"");
        }
    }

    private CSVWriter() {
    }

    static {
        DecimalFormatSymbols symbols = FORMAT.getDecimalFormatSymbols();
        symbols.setNaN("");
        symbols.setDecimalSeparator('.');
        FORMAT.setDecimalFormatSymbols(symbols);
    }
}

