/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;

public final class DataHelper {
    private static final boolean IS_IBM_JVM = System.getProperty("java.vm.vendor").startsWith("IBM");

    public static Map<String, List<Process>> getProcessesByName(ProcessDataSet data, boolean sorted) {
        AbstractMap processNameToProcesses = null;
        processNameToProcesses = sorted ? new TreeMap() : new HashMap();
        for (Process process : data.getProcesses()) {
            ArrayList<Process> processes = (ArrayList<Process>)processNameToProcesses.get(process.getName());
            if (processes == null) {
                processes = new ArrayList<Process>();
                processNameToProcesses.put(process.getName(), processes);
            }
            processes.add(process);
        }
        if (sorted) {
            for (List processes : processNameToProcesses.values()) {
                Collections.sort(processes);
            }
        }
        return processNameToProcesses;
    }

    public static void aggregateProcessData(ProcessDataSet data, Logger logger) {
        long start = System.nanoTime();
        Map<String, List<Process>> processNameToProcesses = DataHelper.getProcessesByName(data, false);
        for (List<Process> processes : processNameToProcesses.values()) {
            if (processes.size() <= 1) continue;
            DataHelper.aggregateProcesses(data, processes, logger);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Aggregated process data for {} in {}ms ", (Object)data, (Object)((double)(System.nanoTime() - start) / 1000000.0));
        }
    }

    private static void aggregateProcesses(ProcessDataSet data, List<Process> processes, Logger logger) {
        long start = System.nanoTime();
        long earliestStart = Long.MAX_VALUE;
        for (Process process : processes) {
            if (process.getStartTime() >= earliestStart) continue;
            earliestStart = process.getStartTime();
        }
        ProcessDataType processType = data.getType(processes.get(0));
        int fieldCount = processType.getFieldCount() + 1;
        String[] fields = new String[fieldCount];
        for (int i = 0; i < fieldCount - 1; ++i) {
            fields[i] = processType.getField(i);
        }
        fields[fieldCount - 1] = "Count";
        String name = processes.get(0).getName();
        Process aggregate = new Process(-1, earliestStart, name);
        aggregate.setCommandLine("all " + name + " processes");
        ProcessDataType aggregateType = new ProcessDataType(aggregate, fields);
        data.addProcess(aggregate);
        data.addType(aggregateType);
        for (DataRecord record : data.getRecords()) {
            double[] totals = new double[fieldCount];
            Arrays.fill(totals, 0.0);
            boolean valid = false;
            for (Process process : processes) {
                processType = data.getType(process);
                if (!record.hasData(processType)) continue;
                valid = true;
                int n = 0;
                for (String field : processType.getFields()) {
                    int n2 = n++;
                    totals[n2] = totals[n2] + record.getData(processType, field);
                }
                int n3 = n;
                totals[n3] = totals[n3] + 1.0;
            }
            if (!valid) continue;
            record.addData(aggregateType, totals);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Aggregated process data for {} in {}ms ", (Object)name, (Object)((double)(System.nanoTime() - start) / 1000000.0));
        }
    }

    public static boolean isNotPartition(String diskName) {
        boolean hdisk = diskName.startsWith("hdisk");
        if ((diskName.startsWith("sd") || diskName.startsWith("hd") && !hdisk || diskName.startsWith("vd") || diskName.startsWith("dasd")) && !Character.isDigit(diskName.charAt(diskName.length() - 1))) {
            return true;
        }
        return hdisk;
    }

    public static SortedSet<String> getInterfaces(DataType type) {
        TreeSet<String> ifaces = new TreeSet<String>();
        for (String field : type.getFields()) {
            int idx = field.indexOf("-read-KB/s");
            if (idx != -1) {
                ifaces.add(field.substring(0, idx));
                continue;
            }
            idx = field.indexOf("-write-KB/s");
            if (idx == -1) continue;
            ifaces.add(field.substring(0, idx));
        }
        return ifaces;
    }

    public static String newString(String original) {
        if (IS_IBM_JVM) {
            return new String(original.trim().toCharArray()).intern();
        }
        return original.trim().intern();
    }

    private DataHelper() {
    }
}

