/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import com.ibm.nmon.NMONVisualizerApp;
import com.ibm.nmon.interval.Interval;

public class GranularityHelper {
    public static int DEFAULT_GRANULARITY = 60000;
    private final NMONVisualizerApp app;
    private int granularity = DEFAULT_GRANULARITY;
    private boolean automatic = false;

    public GranularityHelper(NMONVisualizerApp app) {
        this.app = app;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean automatic) {
        if (this.automatic != automatic) {
            this.automatic = automatic;
            if (this.automatic) {
                this.recalculate();
            }
        }
    }

    public void setGranularity(int granularity) {
        if (granularity < 0) {
            throw new IllegalArgumentException("granularity must be positive");
        }
        this.granularity = granularity;
        this.automatic = false;
    }

    public void recalculate() {
        long granularity;
        if (!this.automatic) {
            throw new IllegalStateException("cannot automatically set granularity; call setAutomatic(true) first");
        }
        long duration = 0L;
        Interval interval = this.app.getIntervalManager().getCurrentInterval();
        if (Interval.DEFAULT.equals(interval)) {
            duration = this.app.getMaxSystemTime() - this.app.getMinSystemTime();
            if (duration == Long.MAX_VALUE) {
                this.granularity = 60000;
                return;
            }
        } else {
            duration = interval.getDuration();
        }
        if ((granularity = duration / 100L) >= Integer.MAX_VALUE) {
            granularity = 2147475000L;
        }
        if ((granularity = Math.round((double)granularity / 15000.0) * 15000L) < 1000L) {
            granularity = 1000L;
        }
        this.granularity = (int)granularity;
    }
}

