/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import com.ibm.nmon.parser.NMONParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserLog
extends Handler {
    private Logger logger;
    private String currentFilename;
    private StringWriter logBuffer;
    private boolean hasData;
    private static final ParserLog INSTANCE = new ParserLog();

    private ParserLog() {
        String loggerName = NMONParser.class.getPackage().getName();
        java.util.logging.Logger parserLogger = java.util.logging.Logger.getLogger(loggerName);
        parserLogger.addHandler(this);
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.currentFilename = "";
        this.logBuffer = new StringWriter(512);
        this.hasData = false;
    }

    public static synchronized ParserLog getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.logBuffer.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.logBuffer = null;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void publish(LogRecord record) {
        this.logBuffer.append(record.getLevel().getName());
        this.logBuffer.append("  ");
        this.logBuffer.append(record.getMessage());
        this.logBuffer.append("\n");
        if (record.getThrown() != null) {
            PrintWriter pw = new PrintWriter(this.logBuffer);
            record.getThrown().printStackTrace(pw);
            pw.close();
        }
        this.hasData = true;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public synchronized boolean hasData() {
        return this.hasData;
    }

    public synchronized String getCurrentFilename() {
        return this.currentFilename;
    }

    public synchronized void setCurrentFilename(String currentFilename) {
        this.currentFilename = currentFilename == null ? "" : currentFilename;
    }

    public synchronized String getMessages() {
        String toReturn = this.logBuffer.toString();
        this.close();
        this.currentFilename = "";
        this.logBuffer = new StringWriter(512);
        this.hasData = false;
        return toReturn;
    }
}

