/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import com.ibm.nmon.interval.Interval;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeFormatCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeFormatCache.class);
    private static final Map<Interval, String> FORMATTED_INTERVALS = new LRUMap<Interval, String>(25);
    private static final Map<Long, String> FORMATTED_DATETIMES = new LRUMap<Long, String>(100);
    private static final Map<Long, String> FORMATTED_TIMES = new LRUMap<Long, String>(100);
    private static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("HH:mm:ss MMM dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static long DEFAULT_INTERVAL_MIN;
    private static long DEFAULT_INTERVAL_MAX;

    public static String formatInterval(Interval interval) {
        String formattedInterval = FORMATTED_INTERVALS.get(interval);
        if (formattedInterval == null) {
            if (Interval.DEFAULT.equals(interval)) {
                formattedInterval = DEFAULT_INTERVAL_MIN > 0L && DEFAULT_INTERVAL_MAX < Long.MAX_VALUE ? "All Data: " + TimeFormatCache.formatDateTime(DEFAULT_INTERVAL_MIN) + " - " + TimeFormatCache.formatDateTime(DEFAULT_INTERVAL_MAX) : "All Data";
            } else {
                formattedInterval = TimeFormatCache.formatDateTime(interval.getStart()) + " - " + TimeFormatCache.formatDateTime(interval.getEnd());
                if (!"".equals(interval.getName())) {
                    String name = interval.getName();
                    if (name.length() > 25) {
                        name = name.substring(0, 22);
                        name = name + "...";
                    }
                    formattedInterval = name + ": " + formattedInterval;
                }
            }
            FORMATTED_INTERVALS.put(interval, formattedInterval);
        }
        return formattedInterval;
    }

    public static void setDefaultIntervalRange(long minTime, long maxTime) {
        DEFAULT_INTERVAL_MIN = minTime;
        DEFAULT_INTERVAL_MAX = maxTime;
        FORMATTED_INTERVALS.remove(Interval.DEFAULT);
    }

    public static void renameInterval(Interval i) {
        FORMATTED_INTERVALS.remove(i);
    }

    public static String formatDateTime(long data) {
        String formattedTime = FORMATTED_DATETIMES.get(data);
        if (formattedTime == null) {
            formattedTime = DATETIME_FORMAT.format(data);
            FORMATTED_DATETIMES.put(data, formattedTime);
        }
        return formattedTime;
    }

    public static String formatTime(long data) {
        String formattedTime = FORMATTED_TIMES.get(data);
        if (formattedTime == null) {
            formattedTime = TIME_FORMAT.format(data);
            FORMATTED_TIMES.put(data, formattedTime);
        }
        return formattedTime;
    }

    public static void setTimeZone(TimeZone timeZone) {
        DATETIME_FORMAT.setTimeZone(timeZone);
        TIME_FORMAT.setTimeZone(timeZone);
        FORMATTED_INTERVALS.clear();
        FORMATTED_DATETIMES.clear();
        FORMATTED_TIMES.clear();
    }

    private TimeFormatCache() {
    }

    private static final class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -1440114072711805032L;
        private final int maxSize;

        LRUMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public V put(K key, V value) {
            V v = super.put(key, value);
            if (v == null) {
                LOGGER.trace("cached {}={}", key, value);
            }
            return v;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            boolean oversized;
            boolean bl = oversized = this.size() > this.maxSize;
            if (oversized) {
                LOGGER.trace("evicted {}={}", eldest.getKey(), eldest.getValue());
            }
            return oversized;
        }
    }
}

