/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionInfo.class);
    private static final String version = VersionInfo.loadVersion();

    public static String getVersion() {
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadVersion() {
        InputStream in = VersionInfo.class.getResourceAsStream("/com/ibm/nmon/version.properties");
        if (in != null) {
            Properties properties = new Properties();
            try {
                properties.load(in);
                String string = properties.getProperty("version");
                return string;
            }
            catch (IOException ioe) {
                LOGGER.warn("Error loading version.properties file", (Throwable)ioe);
                String string = "UNKNOWN";
                return string;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    LOGGER.warn("Cannot close version.properties");
                }
            }
        }
        LOGGER.debug("could not load version.properties; defaulting to 'development'");
        return "development";
    }
}

